/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.vertx;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class ContextRunner {
    private static final Logger logger = LoggerFactory.getLogger(ContextRunner.class);
    private final Vertx vertx;
    private final long timeoutMs;
    private final Context serviceContext;

    public ContextRunner(Vertx vertx, long timeoutMs) {
        this.vertx = Objects.requireNonNull(vertx);
        this.timeoutMs = timeoutMs;
        this.serviceContext = vertx.getOrCreateContext();
    }

    public <T> void runOnNewContext(int times, Handler<Promise<T>> action) {
        this.runOnContext(() -> ((Vertx)this.vertx).getOrCreateContext(), times, action);
    }

    public <T> void runOnServiceContext(Handler<Promise<T>> action) {
        this.runOnContext(() -> this.serviceContext, 1, action);
    }

    private <T> void runOnContext(Supplier<Context> contextFactory, int times, Handler<Promise<T>> action) {
        CountDownLatch completionLatch = new CountDownLatch(times);
        AtomicBoolean actionFailed = new AtomicBoolean(false);
        for (int i = 0; i < times; ++i) {
            Context context = contextFactory.get();
            Promise promise = Promise.promise();
            promise.future().onComplete(ar -> {
                if (ar.failed()) {
                    logger.fatal((Object)"Fatal error occurred while running action on Vertx context", ar.cause());
                    actionFailed.compareAndSet(false, true);
                }
                completionLatch.countDown();
            });
            context.runOnContext(v -> {
                try {
                    action.handle((Object)promise);
                }
                catch (RuntimeException e) {
                    promise.fail((Throwable)e);
                }
            });
        }
        try {
            if (!completionLatch.await(this.timeoutMs, TimeUnit.MILLISECONDS)) {
                throw new RuntimeException("Action has not completed within defined timeout %d ms".formatted(this.timeoutMs));
            }
            if (actionFailed.get()) {
                throw new RuntimeException("Action failed");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while waiting for action to complete", e);
        }
    }
}

