/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.util.system;

import io.vertx.core.Vertx;
import java.util.Objects;
import org.prebid.server.vertx.Initializable;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.HardwareAbstractionLayer;

public class CpuLoadAverageStats
implements Initializable {
    private final SystemInfo systemInfo = new SystemInfo();
    private final HardwareAbstractionLayer hardwareAbstractionLayer = this.systemInfo.getHardware();
    private final CentralProcessor cpu = this.hardwareAbstractionLayer.getProcessor();
    private final Vertx vertx;
    private final long measurementIntervalMillis;
    private volatile double cpuLoadAverage = -1.0;
    private volatile long[] prevTicks = new long[CentralProcessor.TickType.values().length];

    public CpuLoadAverageStats(Vertx vertx, long measurementIntervalMillis) {
        this.vertx = Objects.requireNonNull(vertx);
        this.measurementIntervalMillis = measurementIntervalMillis;
        if (measurementIntervalMillis <= 1000L) {
            throw new IllegalArgumentException("Measurement interval should be greater than 1 second");
        }
    }

    @Override
    public void initialize() {
        this.measureCpuLoad();
        this.vertx.setPeriodic(this.measurementIntervalMillis, timerId -> this.measureCpuLoad());
    }

    private void measureCpuLoad() {
        this.cpuLoadAverage = this.cpu.getSystemCpuLoadBetweenTicks(this.prevTicks);
        this.prevTicks = this.cpu.getSystemCpuLoadTicks();
    }

    public double getCpuLoadAverage() {
        return this.cpuLoadAverage;
    }
}

