/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.util.ResourceUtil;

public final class VersionInfo {
    private static final Logger logger = LoggerFactory.getLogger(VersionInfo.class);
    private static final String UNDEFINED = "undefined";
    private final String version;
    private final String commitHash;

    private VersionInfo(String version, String commitHash) {
        this.version = version;
        this.commitHash = commitHash;
    }

    public static VersionInfo create(String revisionFilePath, JacksonMapper jacksonMapper) {
        Revision revision;
        try {
            revision = (Revision)jacksonMapper.mapper().readValue(ResourceUtil.readFromClasspath(revisionFilePath), Revision.class);
        }
        catch (IOException | IllegalArgumentException e) {
            logger.error((Object)"Was not able to read revision file {0}. Reason: {1}", new Object[]{revisionFilePath, e.getMessage()});
            return new VersionInfo(UNDEFINED, UNDEFINED);
        }
        String pbsVersion = revision.getPbsVersion();
        String commitHash = revision.getCommitHash();
        return new VersionInfo(pbsVersion != null ? VersionInfo.extractVersion(pbsVersion) : UNDEFINED, commitHash != null ? commitHash : UNDEFINED);
    }

    private static String extractVersion(String buildVersion) {
        Pattern versionPattern = Pattern.compile("\\d+\\.\\d+\\.\\d");
        Matcher versionMatcher = versionPattern.matcher(buildVersion);
        return versionMatcher.lookingAt() ? versionMatcher.group() : null;
    }

    public String getVersion() {
        return this.version;
    }

    public String getCommitHash() {
        return this.commitHash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VersionInfo)) {
            return false;
        }
        VersionInfo other = (VersionInfo)o;
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$commitHash = this.getCommitHash();
        String other$commitHash = other.getCommitHash();
        return !(this$commitHash == null ? other$commitHash != null : !this$commitHash.equals(other$commitHash));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $commitHash = this.getCommitHash();
        result = result * 59 + ($commitHash == null ? 43 : $commitHash.hashCode());
        return result;
    }

    public String toString() {
        return "VersionInfo(version=" + this.getVersion() + ", commitHash=" + this.getCommitHash() + ")";
    }

    private static final class Revision {
        @JsonProperty(value="git.commit.id")
        private final String commitHash;
        @JsonProperty(value="git.build.version")
        private final String pbsVersion;

        public String getCommitHash() {
            return this.commitHash;
        }

        public String getPbsVersion() {
            return this.pbsVersion;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Revision)) {
                return false;
            }
            Revision other = (Revision)o;
            String this$commitHash = this.getCommitHash();
            String other$commitHash = other.getCommitHash();
            if (this$commitHash == null ? other$commitHash != null : !this$commitHash.equals(other$commitHash)) {
                return false;
            }
            String this$pbsVersion = this.getPbsVersion();
            String other$pbsVersion = other.getPbsVersion();
            return !(this$pbsVersion == null ? other$pbsVersion != null : !this$pbsVersion.equals(other$pbsVersion));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $commitHash = this.getCommitHash();
            result = result * 59 + ($commitHash == null ? 43 : $commitHash.hashCode());
            String $pbsVersion = this.getPbsVersion();
            result = result * 59 + ($pbsVersion == null ? 43 : $pbsVersion.hashCode());
            return result;
        }

        public String toString() {
            return "VersionInfo.Revision(commitHash=" + this.getCommitHash() + ", pbsVersion=" + this.getPbsVersion() + ")";
        }

        @ConstructorProperties(value={"commitHash", "pbsVersion"})
        private Revision(String commitHash, String pbsVersion) {
            this.commitHash = commitHash;
            this.pbsVersion = pbsVersion;
        }

        public static Revision of(String commitHash, String pbsVersion) {
            return new Revision(commitHash, pbsVersion);
        }
    }
}

