/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.util;

import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Price;
import org.prebid.server.bidder.model.PriceFloorInfo;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;

public class BidderUtil {
    private BidderUtil() {
    }

    public static HttpRequest<BidRequest> defaultRequest(BidRequest bidRequest, String endpointUrl, JacksonMapper mapper) {
        return BidderUtil.defaultRequest(bidRequest, HttpUtil.headers(), endpointUrl, mapper);
    }

    public static HttpRequest<BidRequest> defaultRequest(BidRequest bidRequest, MultiMap headers, String endpointUrl, JacksonMapper mapper) {
        return HttpRequest.builder().method(HttpMethod.POST).uri(endpointUrl).headers(headers).impIds(BidderUtil.impIds(bidRequest)).body(mapper.encodeToBytes(bidRequest)).payload(bidRequest).build();
    }

    public static Set<String> impIds(BidRequest bidRequest) {
        return bidRequest.getImp().stream().map(Imp::getId).collect(Collectors.toSet());
    }

    public static boolean isValidPrice(BigDecimal price) {
        return price != null && price.compareTo(BigDecimal.ZERO) > 0;
    }

    public static boolean isValidPrice(Price price) {
        return BidderUtil.isValidPrice(price.getValue()) && StringUtils.isNotBlank((CharSequence)price.getCurrency());
    }

    public static boolean shouldConvertBidFloor(Price price, String bidderCurrency) {
        return BidderUtil.isValidPrice(price) && !StringUtils.equals((CharSequence)price.getCurrency(), (CharSequence)bidderCurrency);
    }

    public static PriceFloorInfo resolvePriceFloor(Bid bid, BidRequest bidRequest) {
        String bidImpId = ObjectUtil.getIfNotNull(bid, Bid::getImpid);
        if (StringUtils.isEmpty((CharSequence)bidImpId)) {
            return null;
        }
        List imps = ObjectUtil.getIfNotNull(bidRequest, BidRequest::getImp);
        if (CollectionUtils.isEmpty((Collection)imps)) {
            return null;
        }
        return imps.stream().filter(imp -> Objects.equals(bidImpId, imp.getId())).findFirst().map(BidderUtil::createFloorInfo).orElse(null);
    }

    private static PriceFloorInfo createFloorInfo(Imp imp) {
        BigDecimal floor = imp.getBidfloor();
        String currency = imp.getBidfloorcur();
        return floor != null || currency != null ? PriceFloorInfo.of(floor, currency) : null;
    }

    public static BigDecimal roundFloor(BigDecimal floor) {
        if (floor != null) {
            BigDecimal convertedPriceValue = floor.setScale(4, RoundingMode.HALF_EVEN).stripTrailingZeros();
            return convertedPriceValue.scale() < 0 ? convertedPriceValue.setScale(0, RoundingMode.HALF_EVEN) : convertedPriceValue;
        }
        return null;
    }

    public static boolean isNullOrZero(Integer value) {
        return value == null || value == 0;
    }

    public static BidType getBidType(Bid bid, Map<String, Imp> impIdToImpMap) {
        return Optional.ofNullable(impIdToImpMap.get(bid.getImpid())).map(imp -> {
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getXNative() != null) {
                return BidType.xNative;
            }
            if (imp.getAudio() != null) {
                return BidType.audio;
            }
            return BidType.banner;
        }).orElse(BidType.banner);
    }
}

