/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.env;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertySourceFactory;

public class YamlPropertySourceFactory
implements PropertySourceFactory {
    @Nonnull
    public PropertySource<?> createPropertySource(@Nullable String name, @Nonnull EncodedResource resource) throws IOException {
        String sourceName;
        String string = sourceName = name != null ? name : resource.getResource().getFilename();
        if (sourceName == null) {
            throw new IllegalArgumentException("Resource does not have a filename");
        }
        Properties propertiesFromYaml = this.loadYamlIntoProperties(resource);
        return new PropertiesPropertySource(sourceName, propertiesFromYaml);
    }

    public static Properties readPropertiesFromYamlResource(Resource resource) {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResources(new Resource[]{resource});
        factory.afterPropertiesSet();
        return factory.getObject();
    }

    private Properties loadYamlIntoProperties(EncodedResource resource) throws FileNotFoundException {
        try {
            return YamlPropertySourceFactory.readPropertiesFromYamlResource(resource.getResource());
        }
        catch (IllegalStateException e) {
            Throwable cause = e.getCause();
            if (cause instanceof FileNotFoundException) {
                throw (FileNotFoundException)cause;
            }
            throw e;
        }
    }
}

