/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config.bidder;

import javax.validation.constraints.NotBlank;
import org.prebid.server.bidder.BidderDeps;
import org.prebid.server.bidder.improvedigital.ImprovedigitalBidder;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.spring.config.bidder.model.BidderConfigurationProperties;
import org.prebid.server.spring.config.bidder.util.BidderDepsAssembler;
import org.prebid.server.spring.config.bidder.util.UsersyncerCreator;
import org.prebid.server.spring.env.YamlPropertySourceFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:/bidder-config/improvedigital.yaml"}, factory=YamlPropertySourceFactory.class)
public class ImprovedigitalConfiguration {
    private static final String BIDDER_NAME = "improvedigital";

    @Bean(value={"improvedigitalConfigurationProperties"})
    @ConfigurationProperties(value="adapters.improvedigital")
    BidderConfigurationProperties configurationProperties() {
        return new BidderConfigurationProperties();
    }

    @Bean
    BidderDeps improvedigitalBidderDeps(BidderConfigurationProperties improvedigitalConfigurationProperties, @NotBlank @Value(value="${external-url}") String externalUrl, JacksonMapper mapper) {
        return BidderDepsAssembler.forBidder(BIDDER_NAME).withConfig(improvedigitalConfigurationProperties).usersyncerCreator(UsersyncerCreator.create(externalUrl)).bidderCreator(config -> new ImprovedigitalBidder(config.getEndpoint(), mapper)).assemble();
    }
}

