/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.settings.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import org.prebid.server.activity.Activity;
import org.prebid.server.settings.model.AccountCcpaConfig;
import org.prebid.server.settings.model.AccountGdprConfig;
import org.prebid.server.settings.model.activity.AccountActivityConfiguration;
import org.prebid.server.settings.model.activity.privacy.AccountPrivacyModuleConfig;

public final class AccountPrivacyConfig {
    private final AccountGdprConfig gdpr;
    private final AccountCcpaConfig ccpa;
    @JsonProperty(value="allowactivities")
    private final Map<Activity, AccountActivityConfiguration> activities;
    private final List<AccountPrivacyModuleConfig> modules;

    @ConstructorProperties(value={"gdpr", "ccpa", "activities", "modules"})
    private AccountPrivacyConfig(AccountGdprConfig gdpr, AccountCcpaConfig ccpa, Map<Activity, AccountActivityConfiguration> activities, List<AccountPrivacyModuleConfig> modules) {
        this.gdpr = gdpr;
        this.ccpa = ccpa;
        this.activities = activities;
        this.modules = modules;
    }

    public static AccountPrivacyConfig of(AccountGdprConfig gdpr, AccountCcpaConfig ccpa, Map<Activity, AccountActivityConfiguration> activities, List<AccountPrivacyModuleConfig> modules) {
        return new AccountPrivacyConfig(gdpr, ccpa, activities, modules);
    }

    public AccountGdprConfig getGdpr() {
        return this.gdpr;
    }

    public AccountCcpaConfig getCcpa() {
        return this.ccpa;
    }

    public Map<Activity, AccountActivityConfiguration> getActivities() {
        return this.activities;
    }

    public List<AccountPrivacyModuleConfig> getModules() {
        return this.modules;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountPrivacyConfig)) {
            return false;
        }
        AccountPrivacyConfig other = (AccountPrivacyConfig)o;
        AccountGdprConfig this$gdpr = this.getGdpr();
        AccountGdprConfig other$gdpr = other.getGdpr();
        if (this$gdpr == null ? other$gdpr != null : !((Object)this$gdpr).equals(other$gdpr)) {
            return false;
        }
        AccountCcpaConfig this$ccpa = this.getCcpa();
        AccountCcpaConfig other$ccpa = other.getCcpa();
        if (this$ccpa == null ? other$ccpa != null : !((Object)this$ccpa).equals(other$ccpa)) {
            return false;
        }
        Map<Activity, AccountActivityConfiguration> this$activities = this.getActivities();
        Map<Activity, AccountActivityConfiguration> other$activities = other.getActivities();
        if (this$activities == null ? other$activities != null : !((Object)this$activities).equals(other$activities)) {
            return false;
        }
        List<AccountPrivacyModuleConfig> this$modules = this.getModules();
        List<AccountPrivacyModuleConfig> other$modules = other.getModules();
        return !(this$modules == null ? other$modules != null : !((Object)this$modules).equals(other$modules));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AccountGdprConfig $gdpr = this.getGdpr();
        result = result * 59 + ($gdpr == null ? 43 : ((Object)$gdpr).hashCode());
        AccountCcpaConfig $ccpa = this.getCcpa();
        result = result * 59 + ($ccpa == null ? 43 : ((Object)$ccpa).hashCode());
        Map<Activity, AccountActivityConfiguration> $activities = this.getActivities();
        result = result * 59 + ($activities == null ? 43 : ((Object)$activities).hashCode());
        List<AccountPrivacyModuleConfig> $modules = this.getModules();
        result = result * 59 + ($modules == null ? 43 : ((Object)$modules).hashCode());
        return result;
    }

    public String toString() {
        return "AccountPrivacyConfig(gdpr=" + this.getGdpr() + ", ccpa=" + this.getCcpa() + ", activities=" + this.getActivities() + ", modules=" + this.getModules() + ")";
    }
}

