/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.settings.helper;

import io.vertx.core.json.JsonArray;
import io.vertx.ext.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.settings.model.StoredResponseDataResult;

public class JdbcStoredResponseResultMapper {
    private JdbcStoredResponseResultMapper() {
    }

    public static StoredResponseDataResult map(ResultSet resultSet, Set<String> responseIds) {
        HashMap<String, String> storedIdToResponse = new HashMap<String, String>(responseIds.size());
        ArrayList<String> errors = new ArrayList<String>();
        if (resultSet == null || CollectionUtils.isEmpty((Collection)resultSet.getResults())) {
            JdbcStoredResponseResultMapper.handleEmptyResultError(responseIds, errors);
        } else {
            try {
                for (JsonArray result : resultSet.getResults()) {
                    storedIdToResponse.put(result.getString(0), result.getString(1));
                }
            }
            catch (IndexOutOfBoundsException e) {
                errors.add("Result set column number is less than expected");
                return StoredResponseDataResult.of(Collections.emptyMap(), errors);
            }
            errors.addAll(responseIds.stream().filter(id -> !storedIdToResponse.containsKey(id)).map(id -> "No stored response found for id: " + id).toList());
        }
        return StoredResponseDataResult.of(storedIdToResponse, errors);
    }

    private static void handleEmptyResultError(Set<String> responseIds, List<String> errors) {
        if (responseIds.isEmpty()) {
            errors.add("No stored responses found");
        } else {
            errors.add("No stored responses were found for ids: " + String.join((CharSequence)",", responseIds));
        }
    }
}

