/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.settings;

import io.vertx.core.Future;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.prebid.server.execution.Timeout;
import org.prebid.server.settings.ApplicationSettings;
import org.prebid.server.settings.helper.StoredDataFetcher;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.StoredDataResult;
import org.prebid.server.settings.model.StoredResponseDataResult;

public class CompositeApplicationSettings
implements ApplicationSettings {
    private final Proxy proxy;

    public CompositeApplicationSettings(List<ApplicationSettings> delegates) {
        if (Objects.requireNonNull(delegates).isEmpty()) {
            throw new IllegalArgumentException("At least one application settings implementation required");
        }
        this.proxy = CompositeApplicationSettings.createProxy(delegates);
    }

    private static Proxy createProxy(List<ApplicationSettings> delegates) {
        Proxy proxy = null;
        ListIterator<ApplicationSettings> iterator = delegates.listIterator(delegates.size());
        while (iterator.hasPrevious()) {
            proxy = new Proxy(iterator.previous(), proxy);
        }
        return proxy;
    }

    @Override
    public Future<Account> getAccountById(String accountId, Timeout timeout) {
        return this.proxy.getAccountById(accountId, timeout);
    }

    @Override
    public Future<StoredDataResult> getStoredData(String accountId, Set<String> requestIds, Set<String> impIds, Timeout timeout) {
        return this.proxy.getStoredData(accountId, requestIds, impIds, timeout);
    }

    @Override
    public Future<StoredDataResult> getAmpStoredData(String accountId, Set<String> requestIds, Set<String> impIds, Timeout timeout) {
        return this.proxy.getAmpStoredData(accountId, requestIds, Collections.emptySet(), timeout);
    }

    @Override
    public Future<StoredDataResult> getVideoStoredData(String accountId, Set<String> requestIds, Set<String> impIds, Timeout timeout) {
        return this.proxy.getVideoStoredData(accountId, requestIds, impIds, timeout);
    }

    @Override
    public Future<Map<String, String>> getCategories(String primaryAdServer, String publisher, Timeout timeout) {
        return this.proxy.getCategories(primaryAdServer, publisher, timeout);
    }

    @Override
    public Future<StoredResponseDataResult> getStoredResponses(Set<String> responseIds, Timeout timeout) {
        return this.proxy.getStoredResponses(responseIds, timeout);
    }

    private static class Proxy
    implements ApplicationSettings {
        private final ApplicationSettings applicationSettings;
        private final Proxy next;

        private Proxy(ApplicationSettings applicationSettings, Proxy next) {
            this.applicationSettings = applicationSettings;
            this.next = next;
        }

        @Override
        public Future<Account> getAccountById(String accountId, Timeout timeout) {
            return Proxy.getConfig(accountId, timeout, this.applicationSettings::getAccountById, this.next != null ? this.next::getAccountById : null);
        }

        private static <T> Future<T> getConfig(String key, Timeout timeout, BiFunction<String, Timeout, Future<T>> retriever, BiFunction<String, Timeout, Future<T>> nextRetriever) {
            return retriever.apply(key, timeout).recover(throwable -> nextRetriever != null ? (Future)nextRetriever.apply(key, timeout) : Future.failedFuture((Throwable)throwable));
        }

        @Override
        public Future<Map<String, String>> getCategories(String primaryAdServer, String publisher, Timeout timeout) {
            return this.applicationSettings.getCategories(primaryAdServer, publisher, timeout).recover(throwable -> this.next != null ? this.next.getCategories(primaryAdServer, publisher, timeout) : Future.failedFuture((Throwable)throwable));
        }

        @Override
        public Future<StoredDataResult> getStoredData(String accountId, Set<String> requestIds, Set<String> impIds, Timeout timeout) {
            return Proxy.getStoredRequests(accountId, requestIds, impIds, timeout, this.applicationSettings::getStoredData, this.next != null ? this.next::getStoredData : null);
        }

        @Override
        public Future<StoredDataResult> getAmpStoredData(String accountId, Set<String> requestIds, Set<String> impIds, Timeout timeout) {
            return Proxy.getStoredRequests(accountId, requestIds, Collections.emptySet(), timeout, this.applicationSettings::getAmpStoredData, this.next != null ? this.next::getAmpStoredData : null);
        }

        @Override
        public Future<StoredDataResult> getVideoStoredData(String accountId, Set<String> requestIds, Set<String> impIds, Timeout timeout) {
            return Proxy.getStoredRequests(accountId, requestIds, impIds, timeout, this.applicationSettings::getVideoStoredData, this.next != null ? this.next::getVideoStoredData : null);
        }

        @Override
        public Future<StoredResponseDataResult> getStoredResponses(Set<String> responseIds, Timeout timeout) {
            return Proxy.getStoredResponses(responseIds, timeout, this.applicationSettings::getStoredResponses, this.next != null ? this.next::getStoredResponses : null);
        }

        private static Future<StoredResponseDataResult> getStoredResponses(Set<String> responseIds, Timeout timeout, BiFunction<Set<String>, Timeout, Future<StoredResponseDataResult>> retriever, BiFunction<Set<String>, Timeout, Future<StoredResponseDataResult>> nextRetriever) {
            return retriever.apply(responseIds, timeout).compose(retrieverResult -> nextRetriever == null || retrieverResult.getErrors().isEmpty() ? Future.succeededFuture((Object)retrieverResult) : Proxy.getRemainingStoredResponses(responseIds, timeout, retrieverResult.getIdToStoredResponses(), nextRetriever));
        }

        private static Future<StoredDataResult> getStoredRequests(String accountId, Set<String> requestIds, Set<String> impIds, Timeout timeout, StoredDataFetcher<String, Set<String>, Set<String>, Timeout, Future<StoredDataResult>> retriever, StoredDataFetcher<String, Set<String>, Set<String>, Timeout, Future<StoredDataResult>> nextRetriever) {
            return retriever.apply(accountId, requestIds, impIds, timeout).compose(retrieverResult -> nextRetriever == null || retrieverResult.getErrors().isEmpty() ? Future.succeededFuture((Object)retrieverResult) : Proxy.getRemainingStoredRequests(accountId, requestIds, impIds, timeout, retrieverResult.getStoredIdToRequest(), retrieverResult.getStoredIdToImp(), nextRetriever));
        }

        private static Future<StoredDataResult> getRemainingStoredRequests(String accountId, Set<String> requestIds, Set<String> impIds, Timeout timeout, Map<String, String> storedIdToRequest, Map<String, String> storedIdToImp, StoredDataFetcher<String, Set<String>, Set<String>, Timeout, Future<StoredDataResult>> retriever) {
            return retriever.apply(accountId, Proxy.subtractSets(requestIds, storedIdToRequest.keySet()), Proxy.subtractSets(impIds, storedIdToImp.keySet()), timeout).map(result -> StoredDataResult.of(Proxy.combineMaps(storedIdToRequest, result.getStoredIdToRequest()), Proxy.combineMaps(storedIdToImp, result.getStoredIdToImp()), result.getErrors()));
        }

        private static Future<StoredResponseDataResult> getRemainingStoredResponses(Set<String> responseIds, Timeout timeout, Map<String, String> storedSeatBids, BiFunction<Set<String>, Timeout, Future<StoredResponseDataResult>> retriever) {
            return retriever.apply(Proxy.subtractSets(responseIds, storedSeatBids.keySet()), timeout).map(result -> StoredResponseDataResult.of(Proxy.combineMaps(storedSeatBids, result.getIdToStoredResponses()), result.getErrors()));
        }

        private static <T> Set<T> subtractSets(Set<T> first, Set<T> second) {
            HashSet<T> remaining = new HashSet<T>(first);
            remaining.removeAll(second);
            return remaining;
        }

        private static <K, V> Map<K, V> combineMaps(Map<K, V> first, Map<K, V> second) {
            HashMap<K, V> combined = new HashMap<K, V>(first.size() + second.size());
            combined.putAll(first);
            combined.putAll(second);
            return combined;
        }
    }
}

