/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.proto.openrtb.ext;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class FlexibleExtension {
    public static final TypeReference<Map<String, JsonNode>> PROPERTIES_TYPE_REF = new TypeReference<Map<String, JsonNode>>(){};
    private final Map<String, JsonNode> properties = new HashMap<String, JsonNode>();

    public JsonNode getProperty(String property) {
        return this.properties.get(property);
    }

    public boolean containsProperty(String property) {
        return this.properties.containsKey(property);
    }

    @JsonAnyGetter
    public Map<String, JsonNode> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @JsonAnySetter
    public void addProperty(String key, JsonNode value) {
        this.properties.put(key, value);
    }

    public void addProperties(Map<String, JsonNode> properties) {
        this.properties.putAll(properties);
    }

    public String toString() {
        return "FlexibleExtension(properties=" + this.getProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlexibleExtension)) {
            return false;
        }
        FlexibleExtension other = (FlexibleExtension)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, JsonNode> this$properties = this.getProperties();
        Map<String, JsonNode> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlexibleExtension;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, JsonNode> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }
}

