/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.privacy.gdpr.vendorlist.proto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.util.EnumSet;
import org.prebid.server.privacy.gdpr.vendorlist.proto.Feature;
import org.prebid.server.privacy.gdpr.vendorlist.proto.PurposeCode;
import org.prebid.server.privacy.gdpr.vendorlist.proto.SpecialFeature;
import org.prebid.server.privacy.gdpr.vendorlist.proto.SpecialPurpose;

public class Vendor {
    Integer id;
    EnumSet<PurposeCode> purposes;
    @JsonProperty(value="legIntPurposes")
    EnumSet<PurposeCode> legIntPurposes;
    @JsonProperty(value="flexiblePurposes")
    EnumSet<PurposeCode> flexiblePurposes;
    @JsonProperty(value="specialPurposes")
    EnumSet<SpecialPurpose> specialPurposes;
    @JsonProperty(value="features")
    EnumSet<Feature> features;
    @JsonProperty(value="specialFeatures")
    EnumSet<SpecialFeature> specialFeatures;

    public static Vendor empty(Integer id) {
        return Vendor.builder().id(id).purposes(EnumSet.noneOf(PurposeCode.class)).legIntPurposes(EnumSet.noneOf(PurposeCode.class)).flexiblePurposes(EnumSet.noneOf(PurposeCode.class)).specialPurposes(EnumSet.noneOf(SpecialPurpose.class)).features(EnumSet.noneOf(Feature.class)).specialFeatures(EnumSet.noneOf(SpecialFeature.class)).build();
    }

    public static VendorBuilder builder() {
        return new VendorBuilder();
    }

    public VendorBuilder toBuilder() {
        return new VendorBuilder().id(this.id).purposes(this.purposes).legIntPurposes(this.legIntPurposes).flexiblePurposes(this.flexiblePurposes).specialPurposes(this.specialPurposes).features(this.features).specialFeatures(this.specialFeatures);
    }

    @ConstructorProperties(value={"id", "purposes", "legIntPurposes", "flexiblePurposes", "specialPurposes", "features", "specialFeatures"})
    public Vendor(Integer id, EnumSet<PurposeCode> purposes, EnumSet<PurposeCode> legIntPurposes, EnumSet<PurposeCode> flexiblePurposes, EnumSet<SpecialPurpose> specialPurposes, EnumSet<Feature> features, EnumSet<SpecialFeature> specialFeatures) {
        this.id = id;
        this.purposes = purposes;
        this.legIntPurposes = legIntPurposes;
        this.flexiblePurposes = flexiblePurposes;
        this.specialPurposes = specialPurposes;
        this.features = features;
        this.specialFeatures = specialFeatures;
    }

    public Vendor() {
    }

    public Integer getId() {
        return this.id;
    }

    public EnumSet<PurposeCode> getPurposes() {
        return this.purposes;
    }

    public EnumSet<PurposeCode> getLegIntPurposes() {
        return this.legIntPurposes;
    }

    public EnumSet<PurposeCode> getFlexiblePurposes() {
        return this.flexiblePurposes;
    }

    public EnumSet<SpecialPurpose> getSpecialPurposes() {
        return this.specialPurposes;
    }

    public EnumSet<Feature> getFeatures() {
        return this.features;
    }

    public EnumSet<SpecialFeature> getSpecialFeatures() {
        return this.specialFeatures;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setPurposes(EnumSet<PurposeCode> purposes) {
        this.purposes = purposes;
    }

    @JsonProperty(value="legIntPurposes")
    public void setLegIntPurposes(EnumSet<PurposeCode> legIntPurposes) {
        this.legIntPurposes = legIntPurposes;
    }

    @JsonProperty(value="flexiblePurposes")
    public void setFlexiblePurposes(EnumSet<PurposeCode> flexiblePurposes) {
        this.flexiblePurposes = flexiblePurposes;
    }

    @JsonProperty(value="specialPurposes")
    public void setSpecialPurposes(EnumSet<SpecialPurpose> specialPurposes) {
        this.specialPurposes = specialPurposes;
    }

    @JsonProperty(value="features")
    public void setFeatures(EnumSet<Feature> features) {
        this.features = features;
    }

    @JsonProperty(value="specialFeatures")
    public void setSpecialFeatures(EnumSet<SpecialFeature> specialFeatures) {
        this.specialFeatures = specialFeatures;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Vendor)) {
            return false;
        }
        Vendor other = (Vendor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        EnumSet<PurposeCode> this$purposes = this.getPurposes();
        EnumSet<PurposeCode> other$purposes = other.getPurposes();
        if (this$purposes == null ? other$purposes != null : !((Object)this$purposes).equals(other$purposes)) {
            return false;
        }
        EnumSet<PurposeCode> this$legIntPurposes = this.getLegIntPurposes();
        EnumSet<PurposeCode> other$legIntPurposes = other.getLegIntPurposes();
        if (this$legIntPurposes == null ? other$legIntPurposes != null : !((Object)this$legIntPurposes).equals(other$legIntPurposes)) {
            return false;
        }
        EnumSet<PurposeCode> this$flexiblePurposes = this.getFlexiblePurposes();
        EnumSet<PurposeCode> other$flexiblePurposes = other.getFlexiblePurposes();
        if (this$flexiblePurposes == null ? other$flexiblePurposes != null : !((Object)this$flexiblePurposes).equals(other$flexiblePurposes)) {
            return false;
        }
        EnumSet<SpecialPurpose> this$specialPurposes = this.getSpecialPurposes();
        EnumSet<SpecialPurpose> other$specialPurposes = other.getSpecialPurposes();
        if (this$specialPurposes == null ? other$specialPurposes != null : !((Object)this$specialPurposes).equals(other$specialPurposes)) {
            return false;
        }
        EnumSet<Feature> this$features = this.getFeatures();
        EnumSet<Feature> other$features = other.getFeatures();
        if (this$features == null ? other$features != null : !((Object)this$features).equals(other$features)) {
            return false;
        }
        EnumSet<SpecialFeature> this$specialFeatures = this.getSpecialFeatures();
        EnumSet<SpecialFeature> other$specialFeatures = other.getSpecialFeatures();
        return !(this$specialFeatures == null ? other$specialFeatures != null : !((Object)this$specialFeatures).equals(other$specialFeatures));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Vendor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        EnumSet<PurposeCode> $purposes = this.getPurposes();
        result = result * 59 + ($purposes == null ? 43 : ((Object)$purposes).hashCode());
        EnumSet<PurposeCode> $legIntPurposes = this.getLegIntPurposes();
        result = result * 59 + ($legIntPurposes == null ? 43 : ((Object)$legIntPurposes).hashCode());
        EnumSet<PurposeCode> $flexiblePurposes = this.getFlexiblePurposes();
        result = result * 59 + ($flexiblePurposes == null ? 43 : ((Object)$flexiblePurposes).hashCode());
        EnumSet<SpecialPurpose> $specialPurposes = this.getSpecialPurposes();
        result = result * 59 + ($specialPurposes == null ? 43 : ((Object)$specialPurposes).hashCode());
        EnumSet<Feature> $features = this.getFeatures();
        result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
        EnumSet<SpecialFeature> $specialFeatures = this.getSpecialFeatures();
        result = result * 59 + ($specialFeatures == null ? 43 : ((Object)$specialFeatures).hashCode());
        return result;
    }

    public String toString() {
        return "Vendor(id=" + this.getId() + ", purposes=" + this.getPurposes() + ", legIntPurposes=" + this.getLegIntPurposes() + ", flexiblePurposes=" + this.getFlexiblePurposes() + ", specialPurposes=" + this.getSpecialPurposes() + ", features=" + this.getFeatures() + ", specialFeatures=" + this.getSpecialFeatures() + ")";
    }

    public static class VendorBuilder {
        private Integer id;
        private EnumSet<PurposeCode> purposes;
        private EnumSet<PurposeCode> legIntPurposes;
        private EnumSet<PurposeCode> flexiblePurposes;
        private EnumSet<SpecialPurpose> specialPurposes;
        private EnumSet<Feature> features;
        private EnumSet<SpecialFeature> specialFeatures;

        VendorBuilder() {
        }

        public VendorBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public VendorBuilder purposes(EnumSet<PurposeCode> purposes) {
            this.purposes = purposes;
            return this;
        }

        @JsonProperty(value="legIntPurposes")
        public VendorBuilder legIntPurposes(EnumSet<PurposeCode> legIntPurposes) {
            this.legIntPurposes = legIntPurposes;
            return this;
        }

        @JsonProperty(value="flexiblePurposes")
        public VendorBuilder flexiblePurposes(EnumSet<PurposeCode> flexiblePurposes) {
            this.flexiblePurposes = flexiblePurposes;
            return this;
        }

        @JsonProperty(value="specialPurposes")
        public VendorBuilder specialPurposes(EnumSet<SpecialPurpose> specialPurposes) {
            this.specialPurposes = specialPurposes;
            return this;
        }

        @JsonProperty(value="features")
        public VendorBuilder features(EnumSet<Feature> features) {
            this.features = features;
            return this;
        }

        @JsonProperty(value="specialFeatures")
        public VendorBuilder specialFeatures(EnumSet<SpecialFeature> specialFeatures) {
            this.specialFeatures = specialFeatures;
            return this;
        }

        public Vendor build() {
            return new Vendor(this.id, this.purposes, this.legIntPurposes, this.flexiblePurposes, this.specialPurposes, this.features, this.specialFeatures);
        }

        public String toString() {
            return "Vendor.VendorBuilder(id=" + this.id + ", purposes=" + this.purposes + ", legIntPurposes=" + this.legIntPurposes + ", flexiblePurposes=" + this.flexiblePurposes + ", specialPurposes=" + this.specialPurposes + ", features=" + this.features + ", specialFeatures=" + this.specialFeatures + ")";
        }
    }
}

