/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.privacy.gdpr;

import org.prebid.server.auction.BidderAliases;
import org.prebid.server.bidder.BidderCatalog;

public class VendorIdResolver {
    private final BidderAliases aliases;
    private final BidderCatalog bidderCatalog;

    private VendorIdResolver(BidderAliases aliases, BidderCatalog bidderCatalog) {
        this.aliases = aliases;
        this.bidderCatalog = bidderCatalog;
    }

    public static VendorIdResolver of(BidderAliases aliases, BidderCatalog bidderCatalog) {
        return new VendorIdResolver(aliases, bidderCatalog);
    }

    public static VendorIdResolver of(BidderCatalog bidderCatalog) {
        return VendorIdResolver.of(null, bidderCatalog);
    }

    public Integer resolve(String aliasOrBidder) {
        Integer requestAliasVendorId = this.aliases != null ? this.aliases.resolveAliasVendorId(aliasOrBidder) : null;
        return requestAliasVendorId != null ? requestAliasVendorId : this.resolveViaCatalog(aliasOrBidder);
    }

    private Integer resolveViaCatalog(String aliasOrBidder) {
        String bidderName = this.aliases != null ? this.aliases.resolveBidder(aliasOrBidder) : aliasOrBidder;
        return this.bidderCatalog.isActive(bidderName) ? this.bidderCatalog.vendorIdByName(bidderName) : null;
    }
}

