/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.privacy;

import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Regs;
import com.iab.openrtb.request.User;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.exception.InvalidRequestException;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.privacy.ccpa.Ccpa;
import org.prebid.server.privacy.model.Privacy;
import org.prebid.server.proto.request.CookieSyncRequest;

public class PrivacyExtractor {
    private static final Logger logger = LoggerFactory.getLogger(PrivacyExtractor.class);
    private static final String SETUID_GDPR_PARAM = "gdpr";
    private static final String SETUID_GDPR_CONSENT_PARAM = "gdpr_consent";
    private static final String SETUID_GPP_PARAM = "gpp";
    private static final String SETUID_GPP_SID_PARAM = "gpp_sid";
    private static final String DEFAULT_CONSENT_VALUE = "";
    private static final String DEFAULT_GDPR_VALUE = "";
    private static final Ccpa DEFAULT_CCPA_VALUE = Ccpa.EMPTY;
    private static final Integer DEFAULT_COPPA_VALUE = 0;
    private static final String DEFAULT_GPP_VALUE = "";
    private static final List<Integer> DEFAULT_GPP_SID_VALUE = Collections.emptyList();

    public Privacy validPrivacyFrom(BidRequest bidRequest, List<String> errors) {
        return this.extractPrivacy(bidRequest.getRegs(), bidRequest.getUser(), errors);
    }

    public Privacy validPrivacyFrom(CookieSyncRequest request) {
        Integer gdprAsInteger = request.getGdpr();
        String gdpr = gdprAsInteger != null ? gdprAsInteger.toString() : null;
        String gdprConsent = request.getGdprConsent();
        String usPrivacy = request.getUsPrivacy();
        String gpp = request.getGpp();
        List<Integer> gppSid = request.getGppSid();
        return this.toValidPrivacy(gdpr, gdprConsent, usPrivacy, null, gpp, gppSid, null);
    }

    public Privacy validPrivacyFromSetuidRequest(HttpServerRequest request) {
        String gdpr = request.getParam(SETUID_GDPR_PARAM);
        String gdprConsent = request.getParam(SETUID_GDPR_CONSENT_PARAM);
        String gpp = request.getParam(SETUID_GPP_PARAM);
        List<Integer> gppSid = PrivacyExtractor.parseGppSid(request.getParam(SETUID_GPP_SID_PARAM));
        return this.toValidPrivacy(gdpr, gdprConsent, null, null, gpp, gppSid, null);
    }

    private static List<Integer> parseGppSid(String gppSid) {
        if (gppSid == null) {
            return DEFAULT_GPP_SID_VALUE;
        }
        try {
            return Arrays.stream(gppSid.split(",")).map(StringUtils::strip).filter(StringUtils::isNotBlank).map(Integer::parseInt).toList();
        }
        catch (NumberFormatException e) {
            throw new InvalidRequestException("invalid %s value. Comma separated integers expected.".formatted(SETUID_GPP_SID_PARAM));
        }
    }

    private Privacy extractPrivacy(Regs regs, User user, List<String> errors) {
        Integer extRegsGdpr = regs != null ? regs.getGdpr() : null;
        String gdpr = extRegsGdpr != null ? Integer.toString(extRegsGdpr) : null;
        String consent = user != null ? user.getConsent() : null;
        String usPrivacy = regs != null ? regs.getUsPrivacy() : null;
        Integer coppa = regs != null ? regs.getCoppa() : null;
        return this.toValidPrivacy(gdpr, consent, usPrivacy, coppa, null, null, errors);
    }

    public Privacy toValidPrivacy(String gdpr, String consent, String usPrivacy, Integer coppa, String gpp, List<Integer> gppSid, List<String> errors) {
        String validGdpr = ObjectUtils.notEqual((Object)gdpr, (Object)"1") && ObjectUtils.notEqual((Object)gdpr, (Object)"0") ? "" : gdpr;
        String validConsent = StringUtils.defaultString((String)consent, (String)"");
        Ccpa validCcpa = usPrivacy == null ? DEFAULT_CCPA_VALUE : PrivacyExtractor.toValidCcpa(usPrivacy, errors);
        Integer validCoppa = coppa == null ? DEFAULT_COPPA_VALUE : coppa;
        String validGpp = StringUtils.defaultString((String)gpp, (String)"");
        List validGppSid = ListUtils.defaultIfNull(gppSid, DEFAULT_GPP_SID_VALUE);
        return Privacy.builder().gdpr(validGdpr).consentString(validConsent).ccpa(validCcpa).coppa(validCoppa).gpp(validGpp).gppSid(validGppSid).build();
    }

    private static Ccpa toValidCcpa(String usPrivacy, List<String> errors) {
        try {
            Ccpa.validateUsPrivacy(usPrivacy);
            return Ccpa.of(usPrivacy);
        }
        catch (PreBidException e) {
            String message = "CCPA consent %s has invalid format: %s".formatted(usPrivacy, e.getMessage());
            logger.debug((Object)message);
            if (errors != null) {
                errors.add(message);
            }
            return DEFAULT_CCPA_VALUE;
        }
    }
}

