/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.metric;

import com.codahale.metrics.MetricRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.prebid.server.metric.CounterType;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.TcfMetrics;
import org.prebid.server.metric.UpdatableMetrics;

public class CookieSyncMetrics
extends UpdatableMetrics {
    private final Function<String, BidderCookieSyncMetrics> bidderCookieSyncMetricsCreator = bidder -> new BidderCookieSyncMetrics(metricRegistry, counterType, (String)bidder);
    private final Map<String, BidderCookieSyncMetrics> bidderCookieSyncMetrics = new HashMap<String, BidderCookieSyncMetrics>();

    CookieSyncMetrics(MetricRegistry metricRegistry, CounterType counterType) {
        super(Objects.requireNonNull(metricRegistry), Objects.requireNonNull(counterType), metricName -> "cookie_sync." + metricName);
    }

    BidderCookieSyncMetrics forBidder(String bidder) {
        return this.bidderCookieSyncMetrics.computeIfAbsent(bidder.toLowerCase(), this.bidderCookieSyncMetricsCreator);
    }

    static class BidderCookieSyncMetrics
    extends UpdatableMetrics {
        private final TcfMetrics tcfMetrics;

        BidderCookieSyncMetrics(MetricRegistry metricRegistry, CounterType counterType, String bidder) {
            super(Objects.requireNonNull(metricRegistry), Objects.requireNonNull(counterType), BidderCookieSyncMetrics.nameCreator(Objects.requireNonNull(BidderCookieSyncMetrics.createCookieSyncPrefix(bidder))));
            this.tcfMetrics = new TcfMetrics(metricRegistry, counterType, BidderCookieSyncMetrics.createCookieSyncPrefix(bidder));
        }

        TcfMetrics tcf() {
            return this.tcfMetrics;
        }

        private static String createCookieSyncPrefix(String bidder) {
            return "cookie_sync." + bidder;
        }

        private static Function<MetricName, String> nameCreator(String prefix) {
            return metricName -> "%s.%s".formatted(prefix, metricName);
        }
    }
}

