/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.metric;

import com.codahale.metrics.MetricRegistry;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.prebid.server.metric.AdapterTypeMetrics;
import org.prebid.server.metric.CounterType;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.UpdatableMetrics;

class AdapterMetrics
extends UpdatableMetrics {
    private final Function<String, AdapterTypeMetrics> adapterMetricsCreator;
    private final Map<String, AdapterTypeMetrics> adapterMetrics = new CaseInsensitiveMap();

    AdapterMetrics(MetricRegistry metricRegistry, CounterType counterType, String accountPrefix) {
        super(Objects.requireNonNull(metricRegistry), Objects.requireNonNull(counterType), AdapterMetrics.nameCreator(AdapterMetrics.createAdapterSuffix(Objects.requireNonNull(accountPrefix))));
        this.adapterMetricsCreator = adapterType -> new AdapterTypeMetrics(metricRegistry, counterType, AdapterMetrics.createAdapterSuffix(Objects.requireNonNull(accountPrefix)), (String)adapterType);
    }

    private static String createAdapterSuffix(String prefix) {
        return prefix + ".adapter";
    }

    private static Function<MetricName, String> nameCreator(String prefix) {
        return metricName -> "%s.%s".formatted(prefix, metricName);
    }

    AdapterTypeMetrics forAdapter(String adapterType) {
        return this.adapterMetrics.computeIfAbsent(adapterType, this.adapterMetricsCreator);
    }
}

