/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.metric;

import com.codahale.metrics.MetricRegistry;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import org.prebid.server.activity.Activity;
import org.prebid.server.metric.CounterType;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.UpdatableMetrics;

public class ActivitiesMetrics
extends UpdatableMetrics {
    private final Function<Activity, UpdatableMetrics> disallowedActivityMetricCreator = activity -> new UpdatableMetrics(metricRegistry, counterType, ActivitiesMetrics.nameCreator(prefix, ActivitiesMetrics.suffixFromActivity(activity)));
    private final Map<Activity, UpdatableMetrics> disallowedActivityMetrics = new EnumMap<Activity, UpdatableMetrics>(Activity.class);

    ActivitiesMetrics(MetricRegistry metricRegistry, CounterType counterType, String prefix) {
        super(metricRegistry, counterType, ActivitiesMetrics.nameCreator(prefix, ""));
    }

    private static Function<MetricName, String> nameCreator(String prefix, String suffix) {
        return metricName -> "%s.activity.%s%s".formatted(prefix, suffix, metricName);
    }

    private static String suffixFromActivity(Activity activity) {
        return (switch (activity) {
            default -> throw new IncompatibleClassChangeError();
            case Activity.SYNC_USER -> "sync_user";
            case Activity.CALL_BIDDER -> "fetch_bids";
            case Activity.MODIFY_UFDP -> "enrich_ufpd";
            case Activity.TRANSMIT_UFPD -> "transmit_ufpd";
            case Activity.TRANSMIT_GEO -> "transmit_precise_geo";
            case Activity.TRANSMIT_TID -> "transmit_tid";
            case Activity.REPORT_ANALYTICS -> "report_analytics";
        }) + ".";
    }

    UpdatableMetrics forActivity(Activity activity) {
        return this.disallowedActivityMetrics.computeIfAbsent(activity, this.disallowedActivityMetricCreator);
    }
}

