/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.hooks.execution.model;

import java.beans.ConstructorProperties;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.prebid.server.hooks.execution.model.Stage;
import org.prebid.server.hooks.execution.model.StageExecutionOutcome;
import org.prebid.server.model.Endpoint;

public final class HookExecutionContext {
    private final Endpoint endpoint;
    private final EnumMap<Stage, List<StageExecutionOutcome>> stageOutcomes;
    private final Map<String, Object> moduleContexts = new HashMap<String, Object>();

    public static HookExecutionContext of(Endpoint endpoint) {
        return HookExecutionContext.of(endpoint, new EnumMap<Stage, List<StageExecutionOutcome>>(Stage.class));
    }

    @ConstructorProperties(value={"endpoint", "stageOutcomes"})
    private HookExecutionContext(Endpoint endpoint, EnumMap<Stage, List<StageExecutionOutcome>> stageOutcomes) {
        this.endpoint = endpoint;
        this.stageOutcomes = stageOutcomes;
    }

    public static HookExecutionContext of(Endpoint endpoint, EnumMap<Stage, List<StageExecutionOutcome>> stageOutcomes) {
        return new HookExecutionContext(endpoint, stageOutcomes);
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public EnumMap<Stage, List<StageExecutionOutcome>> getStageOutcomes() {
        return this.stageOutcomes;
    }

    public Map<String, Object> getModuleContexts() {
        return this.moduleContexts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HookExecutionContext)) {
            return false;
        }
        HookExecutionContext other = (HookExecutionContext)o;
        Endpoint this$endpoint = this.getEndpoint();
        Endpoint other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !((Object)((Object)this$endpoint)).equals((Object)other$endpoint)) {
            return false;
        }
        EnumMap<Stage, List<StageExecutionOutcome>> this$stageOutcomes = this.getStageOutcomes();
        EnumMap<Stage, List<StageExecutionOutcome>> other$stageOutcomes = other.getStageOutcomes();
        if (this$stageOutcomes == null ? other$stageOutcomes != null : !((Object)this$stageOutcomes).equals(other$stageOutcomes)) {
            return false;
        }
        Map<String, Object> this$moduleContexts = this.getModuleContexts();
        Map<String, Object> other$moduleContexts = other.getModuleContexts();
        return !(this$moduleContexts == null ? other$moduleContexts != null : !((Object)this$moduleContexts).equals(other$moduleContexts));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Endpoint $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : ((Object)((Object)$endpoint)).hashCode());
        EnumMap<Stage, List<StageExecutionOutcome>> $stageOutcomes = this.getStageOutcomes();
        result = result * 59 + ($stageOutcomes == null ? 43 : ((Object)$stageOutcomes).hashCode());
        Map<String, Object> $moduleContexts = this.getModuleContexts();
        result = result * 59 + ($moduleContexts == null ? 43 : ((Object)$moduleContexts).hashCode());
        return result;
    }

    public String toString() {
        return "HookExecutionContext(endpoint=" + this.getEndpoint() + ", stageOutcomes=" + this.getStageOutcomes() + ", moduleContexts=" + this.getModuleContexts() + ")";
    }
}

