/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.hooks.execution;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.logging.LoggerFactory;
import java.time.Clock;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.prebid.server.hooks.execution.FailedException;
import org.prebid.server.hooks.execution.GroupResult;
import org.prebid.server.hooks.execution.InvocationContextProvider;
import org.prebid.server.hooks.execution.RejectedException;
import org.prebid.server.hooks.execution.model.ExecutionGroup;
import org.prebid.server.hooks.execution.model.HookExecutionContext;
import org.prebid.server.hooks.execution.model.HookId;
import org.prebid.server.hooks.v1.Hook;
import org.prebid.server.hooks.v1.InvocationContext;
import org.prebid.server.hooks.v1.InvocationResult;
import org.prebid.server.log.ConditionalLogger;

class GroupExecutor<PAYLOAD, CONTEXT extends InvocationContext> {
    private static final ConditionalLogger conditionalLogger = new ConditionalLogger(LoggerFactory.getLogger(GroupExecutor.class));
    private final Vertx vertx;
    private final Clock clock;
    private ExecutionGroup group;
    private PAYLOAD initialPayload;
    private Function<HookId, Hook<PAYLOAD, CONTEXT>> hookProvider;
    private InvocationContextProvider<CONTEXT> invocationContextProvider;
    private HookExecutionContext hookExecutionContext;
    private boolean rejectAllowed;

    private GroupExecutor(Vertx vertx, Clock clock) {
        this.vertx = vertx;
        this.clock = clock;
    }

    public static <PAYLOAD, CONTEXT extends InvocationContext> GroupExecutor<PAYLOAD, CONTEXT> create(Vertx vertx, Clock clock) {
        return new GroupExecutor<PAYLOAD, CONTEXT>(vertx, clock);
    }

    public GroupExecutor<PAYLOAD, CONTEXT> withGroup(ExecutionGroup group) {
        this.group = group;
        return this;
    }

    public GroupExecutor<PAYLOAD, CONTEXT> withInitialPayload(PAYLOAD initialPayload) {
        this.initialPayload = initialPayload;
        return this;
    }

    public GroupExecutor<PAYLOAD, CONTEXT> withHookProvider(Function<HookId, Hook<PAYLOAD, CONTEXT>> hookProvider) {
        this.hookProvider = hookProvider;
        return this;
    }

    public GroupExecutor<PAYLOAD, CONTEXT> withInvocationContextProvider(InvocationContextProvider<CONTEXT> invocationContextProvider) {
        this.invocationContextProvider = invocationContextProvider;
        return this;
    }

    public GroupExecutor<PAYLOAD, CONTEXT> withHookExecutionContext(HookExecutionContext hookExecutionContext) {
        this.hookExecutionContext = hookExecutionContext;
        return this;
    }

    public GroupExecutor<PAYLOAD, CONTEXT> withRejectAllowed(boolean rejectAllowed) {
        this.rejectAllowed = rejectAllowed;
        return this;
    }

    public Future<GroupResult<PAYLOAD>> execute() {
        GroupResult<PAYLOAD> initialGroupResult = GroupResult.of(this.initialPayload, this.rejectAllowed);
        Future groupFuture = Future.succeededFuture(initialGroupResult);
        for (HookId hookId : this.group.getHookSequence()) {
            Hook<PAYLOAD, CONTEXT> hook = this.hookProvider.apply(hookId);
            long startTime = this.clock.millis();
            Future<InvocationResult<PAYLOAD>> invocationResult = this.executeHook(hook, this.group.getTimeout(), initialGroupResult, hookId);
            groupFuture = groupFuture.compose(groupResult -> this.applyInvocationResult(invocationResult, hookId, startTime, (GroupResult<PAYLOAD>)groupResult));
        }
        return groupFuture.recover(GroupExecutor::restoreResultFromRejection);
    }

    private Future<InvocationResult<PAYLOAD>> executeHook(Hook<PAYLOAD, CONTEXT> hook, Long timeout, GroupResult<PAYLOAD> groupResult, HookId hookId) {
        if (hook == null) {
            conditionalLogger.error("Hook implementation %s does not exist or disabled".formatted(hookId), 0.01);
            return Future.failedFuture((Throwable)new FailedException("Hook implementation does not exist or disabled"));
        }
        return this.executeWithTimeout(() -> hook.call(groupResult.payload(), this.invocationContextProvider.apply(timeout, hookId, this.moduleContextFor(hookId))), timeout);
    }

    private <T> Future<T> executeWithTimeout(Supplier<Future<T>> action, Long timeout) {
        Promise promise = Promise.promise();
        long timeoutTimerId = this.vertx.setTimer(timeout.longValue(), id -> GroupExecutor.failWithTimeout(promise));
        GroupExecutor.executeSafely(action).onComplete(result -> this.completeWithActionResult((Promise)promise, timeoutTimerId, (AsyncResult)result));
        return promise.future();
    }

    private static <T> void failWithTimeout(Promise<T> promise) {
        if (!promise.future().isComplete()) {
            promise.fail((Throwable)new TimeoutException("Timed out while executing action"));
        }
    }

    private static <T> Future<T> executeSafely(Supplier<Future<T>> action) {
        try {
            Future result = action.get();
            return result != null ? result : Future.failedFuture((Throwable)new FailedException("Action returned null"));
        }
        catch (Throwable e) {
            return Future.failedFuture((Throwable)new FailedException(e));
        }
    }

    private <T> void completeWithActionResult(Promise<T> promise, long timeoutTimerId, AsyncResult<T> result) {
        this.vertx.cancelTimer(timeoutTimerId);
        if (!promise.future().isComplete()) {
            promise.handle(result);
        }
    }

    private long executionTime(long startTime) {
        return this.clock.millis() - startTime;
    }

    private Future<GroupResult<PAYLOAD>> applyInvocationResult(Future<InvocationResult<PAYLOAD>> invocationResult, HookId hookId, long startTime, GroupResult<PAYLOAD> groupResult) {
        return invocationResult.map(result -> {
            this.saveModuleContext(hookId, (InvocationResult<PAYLOAD>)result);
            return groupResult.applyInvocationResult((InvocationResult<PAYLOAD>)result, hookId, this.executionTime(startTime));
        }).otherwise(throwable -> groupResult.applyFailure((Throwable)throwable, hookId, this.executionTime(startTime))).compose(this::propagateRejection);
    }

    private Object moduleContextFor(HookId hookId) {
        return this.hookExecutionContext.getModuleContexts().get(hookId.getModuleCode());
    }

    private void saveModuleContext(HookId hookId, InvocationResult<PAYLOAD> result) {
        this.hookExecutionContext.getModuleContexts().put(hookId.getModuleCode(), result.moduleContext());
    }

    private Future<GroupResult<PAYLOAD>> propagateRejection(GroupResult<PAYLOAD> groupResult) {
        return groupResult.shouldReject() ? Future.failedFuture((Throwable)new RejectedException(groupResult)) : Future.succeededFuture(groupResult);
    }

    private static <T> Future<T> restoreResultFromRejection(Throwable throwable) {
        if (throwable instanceof RejectedException) {
            return Future.succeededFuture(((RejectedException)throwable).result());
        }
        return Future.failedFuture((Throwable)throwable);
    }
}

