/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.handler;

import com.fasterxml.jackson.databind.JsonNode;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.BidderCatalog;
import org.prebid.server.cache.CacheService;
import org.prebid.server.cache.proto.request.BidCacheRequest;
import org.prebid.server.cache.proto.request.PutObject;
import org.prebid.server.cache.proto.response.BidCacheResponse;
import org.prebid.server.events.EventUtil;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.execution.Timeout;
import org.prebid.server.execution.TimeoutFactory;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.EncodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.model.Endpoint;
import org.prebid.server.settings.ApplicationSettings;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.AccountAuctionConfig;
import org.prebid.server.settings.model.AccountEventsConfig;
import org.prebid.server.util.HttpUtil;

public class VtrackHandler
implements Handler<RoutingContext> {
    private static final Logger logger = LoggerFactory.getLogger(VtrackHandler.class);
    private static final String ACCOUNT_PARAMETER = "a";
    private static final String INTEGRATION_PARAMETER = "int";
    private static final String TYPE_XML = "xml";
    private final long defaultTimeout;
    private final boolean allowUnknownBidder;
    private final boolean modifyVastForUnknownBidder;
    private final ApplicationSettings applicationSettings;
    private final BidderCatalog bidderCatalog;
    private final CacheService cacheService;
    private final TimeoutFactory timeoutFactory;
    private final JacksonMapper mapper;

    public VtrackHandler(long defaultTimeout, boolean allowUnknownBidder, boolean modifyVastForUnknownBidder, ApplicationSettings applicationSettings, BidderCatalog bidderCatalog, CacheService cacheService, TimeoutFactory timeoutFactory, JacksonMapper mapper) {
        this.defaultTimeout = defaultTimeout;
        this.allowUnknownBidder = allowUnknownBidder;
        this.modifyVastForUnknownBidder = modifyVastForUnknownBidder;
        this.applicationSettings = Objects.requireNonNull(applicationSettings);
        this.bidderCatalog = Objects.requireNonNull(bidderCatalog);
        this.cacheService = Objects.requireNonNull(cacheService);
        this.timeoutFactory = Objects.requireNonNull(timeoutFactory);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public void handle(RoutingContext routingContext) {
        String integration;
        List<PutObject> vtrackPuts;
        String accountId;
        try {
            accountId = VtrackHandler.accountId(routingContext);
            vtrackPuts = this.vtrackPuts(routingContext);
            integration = VtrackHandler.integration(routingContext);
        }
        catch (IllegalArgumentException e) {
            VtrackHandler.respondWith(routingContext, HttpResponseStatus.BAD_REQUEST, e.getMessage());
            return;
        }
        Timeout timeout = this.timeoutFactory.create(this.defaultTimeout);
        this.applicationSettings.getAccountById(accountId, timeout).recover(exception -> VtrackHandler.handleAccountExceptionOrFallback(exception, accountId)).onComplete(async -> this.handleAccountResult((AsyncResult<Account>)async, routingContext, vtrackPuts, accountId, integration, timeout));
    }

    private static String accountId(RoutingContext routingContext) {
        String accountId = routingContext.request().getParam(ACCOUNT_PARAMETER);
        if (StringUtils.isEmpty((CharSequence)accountId)) {
            throw new IllegalArgumentException("Account '%s' is required query parameter and can't be empty".formatted(ACCOUNT_PARAMETER));
        }
        return accountId;
    }

    private List<PutObject> vtrackPuts(RoutingContext routingContext) {
        BidCacheRequest bidCacheRequest;
        Buffer body = routingContext.getBody();
        if (body == null || body.length() == 0) {
            throw new IllegalArgumentException("Incoming request has no body");
        }
        try {
            bidCacheRequest = this.mapper.decodeValue(body, BidCacheRequest.class);
        }
        catch (DecodeException e) {
            throw new IllegalArgumentException("Failed to parse request body", e);
        }
        List putObjects = ListUtils.emptyIfNull(bidCacheRequest.getPuts());
        for (PutObject putObject : putObjects) {
            VtrackHandler.validatePutObject(putObject);
        }
        return putObjects;
    }

    private static void validatePutObject(PutObject putObject) {
        String valueAsString;
        if (StringUtils.isEmpty((CharSequence)putObject.getBidid())) {
            throw new IllegalArgumentException("'bidid' is required field and can't be empty");
        }
        if (StringUtils.isEmpty((CharSequence)putObject.getBidder())) {
            throw new IllegalArgumentException("'bidder' is required field and can't be empty");
        }
        if (!StringUtils.equals((CharSequence)putObject.getType(), (CharSequence)TYPE_XML)) {
            throw new IllegalArgumentException("vtrack only accepts type xml");
        }
        JsonNode value = putObject.getValue();
        String string = valueAsString = value != null ? value.asText() : null;
        if (!StringUtils.containsIgnoreCase((CharSequence)valueAsString, (CharSequence)"<vast")) {
            throw new IllegalArgumentException("vtrack content must be vast");
        }
    }

    public static String integration(RoutingContext routingContext) {
        EventUtil.validateIntegration(routingContext);
        return routingContext.request().getParam(INTEGRATION_PARAMETER);
    }

    private static Future<Account> handleAccountExceptionOrFallback(Throwable exception, String accountId) {
        return exception instanceof PreBidException ? Future.succeededFuture((Object)Account.builder().id(accountId).auction(AccountAuctionConfig.builder().events(AccountEventsConfig.of(false)).build()).build()) : Future.failedFuture((Throwable)exception);
    }

    private void handleAccountResult(AsyncResult<Account> asyncAccount, RoutingContext routingContext, List<PutObject> vtrackPuts, String accountId, String integration, Timeout timeout) {
        if (asyncAccount.failed()) {
            VtrackHandler.respondWithServerError(routingContext, "Error occurred while fetching account", asyncAccount.cause());
        } else {
            Boolean isEventEnabled = VtrackHandler.accountEventsEnabled((Account)asyncAccount.result());
            Set<String> allowedBidders = this.biddersAllowingVastUpdate(vtrackPuts);
            this.cacheService.cachePutObjects(vtrackPuts, isEventEnabled, allowedBidders, accountId, integration, timeout).onComplete(asyncCache -> this.handleCacheResult((AsyncResult<BidCacheResponse>)asyncCache, routingContext));
        }
    }

    private static Boolean accountEventsEnabled(Account account) {
        AccountAuctionConfig accountAuctionConfig = account.getAuction();
        AccountEventsConfig accountEventsConfig = accountAuctionConfig != null ? accountAuctionConfig.getEvents() : null;
        return accountEventsConfig != null ? accountEventsConfig.getEnabled() : null;
    }

    private Set<String> biddersAllowingVastUpdate(List<PutObject> vtrackPuts) {
        return vtrackPuts.stream().map(PutObject::getBidder).filter(this::isAllowVastForBidder).collect(Collectors.toSet());
    }

    private boolean isAllowVastForBidder(String bidderName) {
        if (this.bidderCatalog.isValidName(bidderName)) {
            return this.bidderCatalog.isModifyingVastXmlAllowed(bidderName);
        }
        return this.allowUnknownBidder && this.modifyVastForUnknownBidder;
    }

    private void handleCacheResult(AsyncResult<BidCacheResponse> async, RoutingContext routingContext) {
        if (async.failed()) {
            VtrackHandler.respondWithServerError(routingContext, "Error occurred while sending request to cache", async.cause());
        } else {
            try {
                VtrackHandler.respondWith(routingContext, HttpResponseStatus.OK, this.mapper.encodeToString((BidCacheResponse)async.result()));
            }
            catch (EncodeException e) {
                VtrackHandler.respondWithServerError(routingContext, "Error occurred while encoding response", e);
            }
        }
    }

    private static void respondWithServerError(RoutingContext routingContext, String message, Throwable exception) {
        logger.error((Object)message, exception);
        VtrackHandler.respondWith(routingContext, HttpResponseStatus.INTERNAL_SERVER_ERROR, "%s: %s".formatted(message, exception.getMessage()));
    }

    private static void respondWith(RoutingContext routingContext, HttpResponseStatus status, String body) {
        HttpUtil.executeSafely(routingContext, Endpoint.vtrack, response -> response.putHeader(HttpUtil.CONTENT_TYPE_HEADER, (CharSequence)HttpHeaderValues.APPLICATION_JSON).setStatusCode(status.code()).end(body));
    }
}

