/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.handler;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.RoutingContext;
import java.util.Objects;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.settings.CacheNotificationListener;
import org.prebid.server.settings.proto.request.InvalidateSettingsCacheRequest;
import org.prebid.server.settings.proto.request.UpdateSettingsCacheRequest;
import org.prebid.server.util.HttpUtil;

public class SettingsCacheNotificationHandler
implements Handler<RoutingContext> {
    private final CacheNotificationListener cacheNotificationListener;
    private final JacksonMapper mapper;
    private final String endpoint;

    public SettingsCacheNotificationHandler(CacheNotificationListener cacheNotificationListener, JacksonMapper mapper, String endpoint) {
        this.cacheNotificationListener = Objects.requireNonNull(cacheNotificationListener);
        this.mapper = Objects.requireNonNull(mapper);
        this.endpoint = Objects.requireNonNull(endpoint);
    }

    public void handle(RoutingContext routingContext) {
        switch (routingContext.request().method()) {
            case POST: {
                this.doSave(routingContext);
                break;
            }
            case DELETE: {
                this.doInvalidate(routingContext);
                break;
            }
            default: {
                this.doFail(routingContext);
            }
        }
    }

    private void doSave(RoutingContext routingContext) {
        UpdateSettingsCacheRequest request;
        Buffer body = routingContext.getBody();
        if (body == null) {
            this.respondWithBadRequest(routingContext, "Missing update data.");
            return;
        }
        try {
            request = this.mapper.decodeValue(body, UpdateSettingsCacheRequest.class);
        }
        catch (DecodeException e) {
            this.respondWithBadRequest(routingContext, "Invalid update.");
            return;
        }
        this.cacheNotificationListener.save(request.getRequests(), request.getImps());
        this.respondWith(routingContext, HttpResponseStatus.OK);
    }

    private void doInvalidate(RoutingContext routingContext) {
        InvalidateSettingsCacheRequest request;
        Buffer body = routingContext.getBody();
        if (body == null) {
            this.respondWithBadRequest(routingContext, "Missing invalidation data.");
            return;
        }
        try {
            request = this.mapper.decodeValue(body, InvalidateSettingsCacheRequest.class);
        }
        catch (DecodeException e) {
            this.respondWithBadRequest(routingContext, "Invalid invalidation.");
            return;
        }
        this.cacheNotificationListener.invalidate(request.getRequests(), request.getImps());
        this.respondWith(routingContext, HttpResponseStatus.OK);
    }

    private void doFail(RoutingContext routingContext) {
        this.respondWith(routingContext, HttpResponseStatus.METHOD_NOT_ALLOWED);
    }

    private void respondWithBadRequest(RoutingContext routingContext, String body) {
        HttpUtil.executeSafely(routingContext, this.endpoint, response -> response.setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end(body));
    }

    private void respondWith(RoutingContext routingContext, HttpResponseStatus status) {
        HttpUtil.executeSafely(routingContext, this.endpoint, response -> response.setStatusCode(status.code()).end());
    }
}

