/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.handler;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.deals.DeliveryProgressService;
import org.prebid.server.deals.proto.report.LineItemStatusReport;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.util.HttpUtil;

public class LineItemStatusHandler
implements Handler<RoutingContext> {
    private static final Logger logger = LoggerFactory.getLogger(LineItemStatusHandler.class);
    private static final String ID_PARAM = "id";
    private final DeliveryProgressService deliveryProgressService;
    private final JacksonMapper mapper;
    private final String endpoint;

    public LineItemStatusHandler(DeliveryProgressService deliveryProgressService, JacksonMapper mapper, String endpoint) {
        this.deliveryProgressService = Objects.requireNonNull(deliveryProgressService);
        this.mapper = Objects.requireNonNull(mapper);
        this.endpoint = Objects.requireNonNull(endpoint);
    }

    public void handle(RoutingContext routingContext) {
        routingContext.response().exceptionHandler(LineItemStatusHandler::handleResponseException);
        String lineItemId = LineItemStatusHandler.lineItemIdFrom(routingContext);
        if (StringUtils.isEmpty((CharSequence)lineItemId)) {
            HttpUtil.executeSafely(routingContext, this.endpoint, response -> response.setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("id parameter is required"));
            return;
        }
        try {
            LineItemStatusReport report = this.deliveryProgressService.getLineItemStatusReport(lineItemId);
            HttpUtil.headers().forEach(entry -> routingContext.response().putHeader((String)entry.getKey(), (String)entry.getValue()));
            HttpUtil.executeSafely(routingContext, this.endpoint, response -> response.setStatusCode(HttpResponseStatus.OK.code()).end(this.mapper.encodeToString(report)));
        }
        catch (PreBidException e) {
            HttpUtil.executeSafely(routingContext, this.endpoint, response -> response.setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end(e.getMessage()));
        }
        catch (Exception e) {
            HttpUtil.executeSafely(routingContext, this.endpoint, response -> response.setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).end(e.getMessage()));
        }
    }

    private static String lineItemIdFrom(RoutingContext routingContext) {
        return routingContext.request().getParam(ID_PARAM);
    }

    private static void handleResponseException(Throwable exception) {
        logger.warn((Object)"Failed to send line item status response: {0}", new Object[]{exception.getMessage()});
    }
}

