/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.handler;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BasicAuthHandler;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class CustomizedAdminEndpoint {
    private final String path;
    private final Handler<RoutingContext> handler;
    private final boolean isOnApplicationPort;
    private final boolean isProtected;
    private Map<String, String> credentials;

    public CustomizedAdminEndpoint(String path, Handler<RoutingContext> handler, boolean isOnApplicationPort, boolean isProtected) {
        this.path = Objects.requireNonNull(path);
        this.handler = Objects.requireNonNull(handler);
        this.isOnApplicationPort = isOnApplicationPort;
        this.isProtected = isProtected;
    }

    public CustomizedAdminEndpoint withCredentials(Map<String, String> credentials) {
        this.credentials = credentials;
        return this;
    }

    public boolean isOnApplicationPort() {
        return this.isOnApplicationPort;
    }

    public void router(Router router) {
        if (this.isProtected) {
            this.routeToHandlerWithCredentials(router);
        } else {
            this.routeToHandler(router);
        }
    }

    private void routeToHandlerWithCredentials(Router router) {
        if (this.credentials == null) {
            throw new IllegalArgumentException("Credentials for admin endpoint is empty.");
        }
        AuthProvider authProvider = this.createAuthProvider(this.credentials);
        router.route(this.path).handler((Handler)BasicAuthHandler.create((AuthProvider)authProvider)).handler(this.handler);
    }

    private void routeToHandler(Router router) {
        router.route(this.path).handler(this.handler);
    }

    private AuthProvider createAuthProvider(Map<String, String> credentials) {
        return (authInfo, resultHandler) -> {
            if (MapUtils.isEmpty((Map)credentials)) {
                resultHandler.handle((Object)Future.failedFuture((String)"Credentials not set in configuration."));
                return;
            }
            String requestUsername = authInfo.getString("username");
            String requestPassword = StringUtils.chomp((String)authInfo.getString("password"));
            String storedPassword = (String)credentials.get(requestUsername);
            if (StringUtils.isNotBlank((CharSequence)requestPassword) && Objects.equals(storedPassword, requestPassword)) {
                resultHandler.handle((Object)Future.succeededFuture());
            } else {
                resultHandler.handle((Object)Future.failedFuture((String)"No such user, or password incorrect."));
            }
        };
    }
}

