/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.handler;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.prebid.server.currency.CurrencyConversionService;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.util.HttpUtil;

public class CurrencyRatesHandler
implements Handler<RoutingContext> {
    private static final Logger logger = LoggerFactory.getLogger(CurrencyRatesHandler.class);
    private final CurrencyConversionService currencyConversionService;
    private final String endpoint;
    private final JacksonMapper mapper;

    public CurrencyRatesHandler(CurrencyConversionService currencyConversionService, String endpoint, JacksonMapper mapper) {
        this.currencyConversionService = Objects.requireNonNull(currencyConversionService);
        this.endpoint = Objects.requireNonNull(endpoint);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public void handle(RoutingContext routingContext) {
        try {
            String body = this.mapper.mapper().writeValueAsString((Object)Response.of(this.currencyConversionService.isExternalRatesActive(), this.currencyConversionService.getCurrencyServerUrl(), CurrencyRatesHandler.toNanos(this.currencyConversionService.getRefreshPeriod()), this.currencyConversionService.getLastUpdated(), this.currencyConversionService.getExternalCurrencyRates()));
            this.respondWithOk(routingContext, body);
        }
        catch (IOException e) {
            this.respondWithServerError(routingContext, e);
        }
    }

    private static Long toNanos(Long refreshPeriod) {
        return refreshPeriod != null ? Long.valueOf(TimeUnit.MILLISECONDS.toNanos(refreshPeriod)) : null;
    }

    private void respondWithOk(RoutingContext routingContext, String body) {
        this.respondWith(routingContext, HttpResponseStatus.OK, body);
    }

    private void respondWithServerError(RoutingContext routingContext, Throwable exception) {
        String message = "Critical error when marshaling latest currency rates update response";
        logger.error((Object)"Critical error when marshaling latest currency rates update response", exception);
        this.respondWith(routingContext, HttpResponseStatus.INTERNAL_SERVER_ERROR, "Critical error when marshaling latest currency rates update response");
    }

    private void respondWith(RoutingContext routingContext, HttpResponseStatus status, String body) {
        HttpUtil.executeSafely(routingContext, this.endpoint, response -> response.setStatusCode(status.code()).putHeader(HttpUtil.CONTENT_TYPE_HEADER, (CharSequence)HttpHeaderValues.APPLICATION_JSON).end(body));
    }

    private static final class Response {
        private final boolean active;
        private final String source;
        @JsonProperty(value="fetchingIntervalNs")
        private final Long fetchingIntervalNs;
        @JsonProperty(value="lastUpdated")
        private final ZonedDateTime lastUpdated;
        private final Map<String, Map<String, BigDecimal>> rates;

        public boolean isActive() {
            return this.active;
        }

        public String getSource() {
            return this.source;
        }

        public Long getFetchingIntervalNs() {
            return this.fetchingIntervalNs;
        }

        public ZonedDateTime getLastUpdated() {
            return this.lastUpdated;
        }

        public Map<String, Map<String, BigDecimal>> getRates() {
            return this.rates;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            if (this.isActive() != other.isActive()) {
                return false;
            }
            Long this$fetchingIntervalNs = this.getFetchingIntervalNs();
            Long other$fetchingIntervalNs = other.getFetchingIntervalNs();
            if (this$fetchingIntervalNs == null ? other$fetchingIntervalNs != null : !((Object)this$fetchingIntervalNs).equals(other$fetchingIntervalNs)) {
                return false;
            }
            String this$source = this.getSource();
            String other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            ZonedDateTime this$lastUpdated = this.getLastUpdated();
            ZonedDateTime other$lastUpdated = other.getLastUpdated();
            if (this$lastUpdated == null ? other$lastUpdated != null : !((Object)this$lastUpdated).equals(other$lastUpdated)) {
                return false;
            }
            Map<String, Map<String, BigDecimal>> this$rates = this.getRates();
            Map<String, Map<String, BigDecimal>> other$rates = other.getRates();
            return !(this$rates == null ? other$rates != null : !((Object)this$rates).equals(other$rates));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isActive() ? 79 : 97);
            Long $fetchingIntervalNs = this.getFetchingIntervalNs();
            result = result * 59 + ($fetchingIntervalNs == null ? 43 : ((Object)$fetchingIntervalNs).hashCode());
            String $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            ZonedDateTime $lastUpdated = this.getLastUpdated();
            result = result * 59 + ($lastUpdated == null ? 43 : ((Object)$lastUpdated).hashCode());
            Map<String, Map<String, BigDecimal>> $rates = this.getRates();
            result = result * 59 + ($rates == null ? 43 : ((Object)$rates).hashCode());
            return result;
        }

        public String toString() {
            return "CurrencyRatesHandler.Response(active=" + this.isActive() + ", source=" + this.getSource() + ", fetchingIntervalNs=" + this.getFetchingIntervalNs() + ", lastUpdated=" + this.getLastUpdated() + ", rates=" + this.getRates() + ")";
        }

        @ConstructorProperties(value={"active", "source", "fetchingIntervalNs", "lastUpdated", "rates"})
        private Response(boolean active, String source, Long fetchingIntervalNs, ZonedDateTime lastUpdated, Map<String, Map<String, BigDecimal>> rates) {
            this.active = active;
            this.source = source;
            this.fetchingIntervalNs = fetchingIntervalNs;
            this.lastUpdated = lastUpdated;
            this.rates = rates;
        }

        public static Response of(boolean active, String source, Long fetchingIntervalNs, ZonedDateTime lastUpdated, Map<String, Map<String, BigDecimal>> rates) {
            return new Response(active, source, fetchingIntervalNs, lastUpdated, rates);
        }
    }
}

