/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.floors;

import io.vertx.core.Future;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.log.ConditionalLogger;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.Metrics;
import org.prebid.server.settings.EnrichingApplicationSettings;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.AccountAuctionConfig;
import org.prebid.server.settings.model.AccountPriceFloorsConfig;
import org.prebid.server.settings.model.AccountPriceFloorsFetchConfig;
import org.prebid.server.util.ObjectUtil;

public class PriceFloorsConfigResolver {
    private static final Logger logger = LoggerFactory.getLogger(EnrichingApplicationSettings.class);
    private static final ConditionalLogger conditionalLogger = new ConditionalLogger(logger);
    private static final int MIN_MAX_AGE_SEC_VALUE = 600;
    private static final int MIN_PERIODIC_SEC_VALUE = 300;
    private static final int MIN_TIMEOUT_MS_VALUE = 10;
    private static final int MAX_TIMEOUT_MS_VALUE = 10000;
    private static final int MIN_RULES_VALUE = 0;
    private static final int MIN_FILE_SIZE_VALUE = 0;
    private static final int MAX_AGE_SEC_VALUE = Integer.MAX_VALUE;
    private static final int MAX_RULES_VALUE = Integer.MAX_VALUE;
    private static final int MAX_FILE_SIZE_VALUE = Integer.MAX_VALUE;
    private static final int MIN_ENFORCE_RATE_VALUE = 0;
    private static final int MAX_ENFORCE_RATE_VALUE = 100;
    private static final long DEFAULT_MAX_AGE_SEC_VALUE = 86400L;
    private final Account defaultAccount;
    private final Metrics metrics;
    private final AccountPriceFloorsConfig defaultFloorsConfig;

    public PriceFloorsConfigResolver(String defaultAccountConfig, Metrics metrics, JacksonMapper mapper) {
        this.defaultAccount = PriceFloorsConfigResolver.parseAccount(defaultAccountConfig, mapper);
        this.defaultFloorsConfig = PriceFloorsConfigResolver.getFloorsConfig(this.defaultAccount);
        this.metrics = Objects.requireNonNull(metrics);
    }

    private static Account parseAccount(String accountConfig, JacksonMapper mapper) {
        try {
            Account account = StringUtils.isNotBlank((CharSequence)accountConfig) ? mapper.decodeValue(accountConfig, Account.class) : null;
            return PriceFloorsConfigResolver.isNotEmpty(account) ? account : null;
        }
        catch (DecodeException e) {
            throw new IllegalArgumentException("Could not parse default account configuration", e);
        }
    }

    private static AccountPriceFloorsConfig getFloorsConfig(Account account) {
        AccountAuctionConfig auctionConfig = ObjectUtil.getIfNotNull(account, Account::getAuction);
        return ObjectUtil.getIfNotNull(auctionConfig, AccountAuctionConfig::getPriceFloors);
    }

    private static boolean isNotEmpty(Account account) {
        return account != null && !account.equals(Account.builder().build());
    }

    public Future<Account> updateFloorsConfig(Account account) {
        try {
            PriceFloorsConfigResolver.validatePriceFloorConfig(account, this.defaultFloorsConfig);
            return Future.succeededFuture((Object)account);
        }
        catch (PreBidException e) {
            String message = "Account with id '%s' has invalid config: %s".formatted(account.getId(), e.getMessage());
            String accountId = ObjectUtil.getIfNotNull(account, Account::getId);
            if (StringUtils.isNotBlank((CharSequence)accountId)) {
                this.metrics.updateAlertsConfigFailed(account.getId(), MetricName.price_floors);
            }
            conditionalLogger.error(message, 0.01);
            return Future.succeededFuture((Object)this.fallbackToDefaultConfig(account));
        }
    }

    private static void validatePriceFloorConfig(Account account, AccountPriceFloorsConfig defaultFloorsConfig) {
        Integer enforceFloorsRate;
        AccountPriceFloorsConfig floorsConfig = PriceFloorsConfigResolver.getFloorsConfig(account);
        if (floorsConfig == null) {
            return;
        }
        Integer accountEnforceRate = floorsConfig.getEnforceFloorsRate();
        Integer n = enforceFloorsRate = accountEnforceRate != null ? accountEnforceRate : ObjectUtil.getIfNotNull(defaultFloorsConfig, AccountPriceFloorsConfig::getEnforceFloorsRate);
        if (enforceFloorsRate != null && PriceFloorsConfigResolver.isNotInRange(enforceFloorsRate.intValue(), 0L, 100L)) {
            throw new PreBidException(PriceFloorsConfigResolver.invalidPriceFloorsPropertyMessage("enforce-floors-rate", enforceFloorsRate));
        }
        AccountPriceFloorsFetchConfig fetchConfig = ObjectUtil.getIfNotNull(floorsConfig, AccountPriceFloorsConfig::getFetch);
        AccountPriceFloorsFetchConfig defaultFetchConfig = ObjectUtil.getIfNotNull(defaultFloorsConfig, AccountPriceFloorsConfig::getFetch);
        PriceFloorsConfigResolver.validatePriceFloorsFetchConfig(fetchConfig, defaultFetchConfig);
    }

    private static void validatePriceFloorsFetchConfig(AccountPriceFloorsFetchConfig fetchConfig, AccountPriceFloorsFetchConfig defaultFetchConfig) {
        Long maxFileSize;
        Long maxRules;
        Long timeout;
        Long periodicSec;
        long maxAgeSec;
        if (fetchConfig == null) {
            return;
        }
        Long accountMaxAgeSec = fetchConfig.getMaxAgeSec();
        Long defaultMaxAgeSec = ObjectUtil.getIfNotNull(defaultFetchConfig, AccountPriceFloorsFetchConfig::getMaxAgeSec);
        long l = accountMaxAgeSec != null ? accountMaxAgeSec : (maxAgeSec = defaultMaxAgeSec != null ? defaultMaxAgeSec : 86400L);
        if (PriceFloorsConfigResolver.isNotInRange(maxAgeSec, 600L, Integer.MAX_VALUE)) {
            throw new PreBidException(PriceFloorsConfigResolver.invalidPriceFloorsPropertyMessage("max-age-sec", maxAgeSec));
        }
        Long accountPeriodicSec = fetchConfig.getPeriodSec();
        Long l2 = periodicSec = accountPeriodicSec != null ? accountPeriodicSec : ObjectUtil.getIfNotNull(defaultFetchConfig, AccountPriceFloorsFetchConfig::getPeriodSec);
        if (periodicSec != null && PriceFloorsConfigResolver.isNotInRange(periodicSec, 300L, maxAgeSec)) {
            throw new PreBidException(PriceFloorsConfigResolver.invalidPriceFloorsPropertyMessage("period-sec", periodicSec));
        }
        Long accountTimeout = fetchConfig.getTimeout();
        Long l3 = timeout = accountTimeout != null ? accountTimeout : ObjectUtil.getIfNotNull(defaultFetchConfig, AccountPriceFloorsFetchConfig::getTimeout);
        if (timeout != null && PriceFloorsConfigResolver.isNotInRange(timeout, 10L, 10000L)) {
            throw new PreBidException(PriceFloorsConfigResolver.invalidPriceFloorsPropertyMessage("timeout-ms", timeout));
        }
        Long accountMaxRules = fetchConfig.getMaxRules();
        Long l4 = maxRules = accountMaxRules != null ? accountMaxRules : ObjectUtil.getIfNotNull(defaultFetchConfig, AccountPriceFloorsFetchConfig::getMaxRules);
        if (maxRules != null && PriceFloorsConfigResolver.isNotInRange(maxRules, 0L, Integer.MAX_VALUE)) {
            throw new PreBidException(PriceFloorsConfigResolver.invalidPriceFloorsPropertyMessage("max-rules", maxRules));
        }
        Long accountMaxFileSize = fetchConfig.getMaxFileSize();
        Long l5 = maxFileSize = accountMaxFileSize != null ? accountMaxFileSize : ObjectUtil.getIfNotNull(defaultFetchConfig, AccountPriceFloorsFetchConfig::getMaxFileSize);
        if (maxFileSize != null && PriceFloorsConfigResolver.isNotInRange(maxFileSize, 0L, Integer.MAX_VALUE)) {
            throw new PreBidException(PriceFloorsConfigResolver.invalidPriceFloorsPropertyMessage("max-file-size-kb", maxFileSize));
        }
    }

    private static boolean isNotInRange(long number, long min, long max) {
        return Math.max(min, number) != Math.min(number, max);
    }

    private static String invalidPriceFloorsPropertyMessage(String property, Object value) {
        return "Invalid price-floors property '%s', value passed: %s".formatted(property, value);
    }

    private Account fallbackToDefaultConfig(Account account) {
        AccountAuctionConfig auctionConfig = account.getAuction();
        AccountAuctionConfig defaultAuctionConfig = ObjectUtil.getIfNotNull(this.defaultAccount, Account::getAuction);
        AccountPriceFloorsConfig defaultPriceFloorsConfig = ObjectUtil.getIfNotNull(defaultAuctionConfig, AccountAuctionConfig::getPriceFloors);
        return account.toBuilder().auction(auctionConfig.toBuilder().priceFloors(defaultPriceFloorsConfig).build()).build();
    }
}

