/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.floors;

import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.auction.adjustment.FloorAdjustmentFactorResolver;
import org.prebid.server.floors.PriceFloorAdjuster;
import org.prebid.server.floors.model.PriceFloorEnforcement;
import org.prebid.server.floors.model.PriceFloorRules;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestBidAdjustmentFactors;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.proto.openrtb.ext.request.ImpMediaType;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.AccountAuctionConfig;
import org.prebid.server.settings.model.AccountPriceFloorsConfig;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.ObjectUtil;

public class BasicPriceFloorAdjuster
implements PriceFloorAdjuster {
    private static final int ADJUSTMENT_SCALE = 4;
    private final FloorAdjustmentFactorResolver floorAdjustmentFactorResolver;

    public BasicPriceFloorAdjuster(FloorAdjustmentFactorResolver floorAdjustmentFactorResolver) {
        this.floorAdjustmentFactorResolver = Objects.requireNonNull(floorAdjustmentFactorResolver);
    }

    @Override
    public BigDecimal adjustForImp(Imp imp, String bidder, BidRequest bidRequest, Account account) {
        ExtRequestBidAdjustmentFactors extractBidAdjustmentFactors = BasicPriceFloorAdjuster.extractBidAdjustmentFactors(bidRequest);
        BigDecimal impBidFloor = imp.getBidfloor();
        if (!BasicPriceFloorAdjuster.shouldAdjustBidFloor(bidRequest, account) || impBidFloor == null || extractBidAdjustmentFactors == null) {
            return impBidFloor;
        }
        Set<ImpMediaType> impMediaTypes = BasicPriceFloorAdjuster.retrieveImpMediaTypes(imp);
        BigDecimal factor = this.floorAdjustmentFactorResolver.resolve(impMediaTypes, extractBidAdjustmentFactors, bidder);
        return factor != null ? BidderUtil.roundFloor(impBidFloor.divide(factor, 4, RoundingMode.HALF_EVEN)) : impBidFloor;
    }

    private static boolean shouldAdjustBidFloor(BidRequest bidRequest, Account account) {
        Boolean shouldAdjustBidFloor = (Boolean)ObjectUtils.defaultIfNull((Object)BasicPriceFloorAdjuster.shouldAdjustBidFloorByRequest(bidRequest), (Object)BasicPriceFloorAdjuster.shouldAdjustBidFloorByAccount(account));
        return (Boolean)ObjectUtils.defaultIfNull((Object)shouldAdjustBidFloor, (Object)true);
    }

    private static Set<ImpMediaType> retrieveImpMediaTypes(Imp imp) {
        EnumSet<ImpMediaType> availableMediaTypes = EnumSet.noneOf(ImpMediaType.class);
        if (imp.getBanner() != null) {
            availableMediaTypes.add(ImpMediaType.banner);
        }
        if (imp.getVideo() != null) {
            Integer placement = imp.getVideo().getPlacement();
            if (placement == null || Objects.equals(placement, 1)) {
                availableMediaTypes.add(ImpMediaType.video);
            } else {
                availableMediaTypes.add(ImpMediaType.video_outstream);
            }
        }
        if (imp.getXNative() != null) {
            availableMediaTypes.add(ImpMediaType.xNative);
        }
        if (imp.getAudio() != null) {
            availableMediaTypes.add(ImpMediaType.audio);
        }
        return availableMediaTypes;
    }

    private static Boolean shouldAdjustBidFloorByRequest(BidRequest bidRequest) {
        ExtRequest extRequest = bidRequest.getExt();
        ExtRequestPrebid extPrebid = ObjectUtil.getIfNotNull(extRequest, ExtRequest::getPrebid);
        PriceFloorRules floorRules = ObjectUtil.getIfNotNull(extPrebid, ExtRequestPrebid::getFloors);
        PriceFloorEnforcement enforcement = ObjectUtil.getIfNotNull(floorRules, PriceFloorRules::getEnforcement);
        return ObjectUtil.getIfNotNull(enforcement, PriceFloorEnforcement::getBidAdjustment);
    }

    private static Boolean shouldAdjustBidFloorByAccount(Account account) {
        AccountAuctionConfig auctionConfig = ObjectUtil.getIfNotNull(account, Account::getAuction);
        AccountPriceFloorsConfig floorsConfig = ObjectUtil.getIfNotNull(auctionConfig, AccountAuctionConfig::getPriceFloors);
        return ObjectUtil.getIfNotNull(floorsConfig, AccountPriceFloorsConfig::getAdjustForBidAdjustment);
    }

    private static ExtRequestBidAdjustmentFactors extractBidAdjustmentFactors(BidRequest bidRequest) {
        ExtRequest extRequest = bidRequest.getExt();
        ExtRequestPrebid extPrebid = ObjectUtil.getIfNotNull(extRequest, ExtRequest::getPrebid);
        return ObjectUtil.getIfNotNull(extPrebid, ExtRequestPrebid::getBidadjustmentfactors);
    }
}

