/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.execution.retry;

import java.beans.ConstructorProperties;
import org.prebid.server.execution.retry.NonRetryable;
import org.prebid.server.execution.retry.RetryPolicy;
import org.prebid.server.execution.retry.Retryable;

public final class FixedIntervalRetryPolicy
implements Retryable {
    private final long delay;
    private final Integer retriesLeft;

    public static FixedIntervalRetryPolicy limited(long delay, int retryLimit) {
        return new FixedIntervalRetryPolicy(delay, retryLimit);
    }

    public static FixedIntervalRetryPolicy of(long delay) {
        return new FixedIntervalRetryPolicy(delay, null);
    }

    @Override
    public RetryPolicy next() {
        if (this.retriesLeft == null) {
            return this;
        }
        return this.retriesLeft - 1 > 0 ? FixedIntervalRetryPolicy.limited(this.delay, this.retriesLeft - 1) : NonRetryable.instance();
    }

    @ConstructorProperties(value={"delay", "retriesLeft"})
    public FixedIntervalRetryPolicy(long delay, Integer retriesLeft) {
        this.delay = delay;
        this.retriesLeft = retriesLeft;
    }

    @Override
    public long delay() {
        return this.delay;
    }

    public Integer retriesLeft() {
        return this.retriesLeft;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FixedIntervalRetryPolicy)) {
            return false;
        }
        FixedIntervalRetryPolicy other = (FixedIntervalRetryPolicy)o;
        if (this.delay() != other.delay()) {
            return false;
        }
        Integer this$retriesLeft = this.retriesLeft();
        Integer other$retriesLeft = other.retriesLeft();
        return !(this$retriesLeft == null ? other$retriesLeft != null : !((Object)this$retriesLeft).equals(other$retriesLeft));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $delay = this.delay();
        result = result * 59 + (int)($delay >>> 32 ^ $delay);
        Integer $retriesLeft = this.retriesLeft();
        result = result * 59 + ($retriesLeft == null ? 43 : ((Object)$retriesLeft).hashCode());
        return result;
    }

    public String toString() {
        return "FixedIntervalRetryPolicy(delay=" + this.delay() + ", retriesLeft=" + this.retriesLeft() + ")";
    }
}

