/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.events;

import java.beans.ConstructorProperties;

public final class EventsContext {
    private final boolean enabledForAccount;
    private final boolean enabledForRequest;
    private final String auctionId;
    private final Long auctionTimestamp;
    private final String integration;

    @ConstructorProperties(value={"enabledForAccount", "enabledForRequest", "auctionId", "auctionTimestamp", "integration"})
    EventsContext(boolean enabledForAccount, boolean enabledForRequest, String auctionId, Long auctionTimestamp, String integration) {
        this.enabledForAccount = enabledForAccount;
        this.enabledForRequest = enabledForRequest;
        this.auctionId = auctionId;
        this.auctionTimestamp = auctionTimestamp;
        this.integration = integration;
    }

    public static EventsContextBuilder builder() {
        return new EventsContextBuilder();
    }

    public boolean isEnabledForAccount() {
        return this.enabledForAccount;
    }

    public boolean isEnabledForRequest() {
        return this.enabledForRequest;
    }

    public String getAuctionId() {
        return this.auctionId;
    }

    public Long getAuctionTimestamp() {
        return this.auctionTimestamp;
    }

    public String getIntegration() {
        return this.integration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventsContext)) {
            return false;
        }
        EventsContext other = (EventsContext)o;
        if (this.isEnabledForAccount() != other.isEnabledForAccount()) {
            return false;
        }
        if (this.isEnabledForRequest() != other.isEnabledForRequest()) {
            return false;
        }
        Long this$auctionTimestamp = this.getAuctionTimestamp();
        Long other$auctionTimestamp = other.getAuctionTimestamp();
        if (this$auctionTimestamp == null ? other$auctionTimestamp != null : !((Object)this$auctionTimestamp).equals(other$auctionTimestamp)) {
            return false;
        }
        String this$auctionId = this.getAuctionId();
        String other$auctionId = other.getAuctionId();
        if (this$auctionId == null ? other$auctionId != null : !this$auctionId.equals(other$auctionId)) {
            return false;
        }
        String this$integration = this.getIntegration();
        String other$integration = other.getIntegration();
        return !(this$integration == null ? other$integration != null : !this$integration.equals(other$integration));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabledForAccount() ? 79 : 97);
        result = result * 59 + (this.isEnabledForRequest() ? 79 : 97);
        Long $auctionTimestamp = this.getAuctionTimestamp();
        result = result * 59 + ($auctionTimestamp == null ? 43 : ((Object)$auctionTimestamp).hashCode());
        String $auctionId = this.getAuctionId();
        result = result * 59 + ($auctionId == null ? 43 : $auctionId.hashCode());
        String $integration = this.getIntegration();
        result = result * 59 + ($integration == null ? 43 : $integration.hashCode());
        return result;
    }

    public String toString() {
        return "EventsContext(enabledForAccount=" + this.isEnabledForAccount() + ", enabledForRequest=" + this.isEnabledForRequest() + ", auctionId=" + this.getAuctionId() + ", auctionTimestamp=" + this.getAuctionTimestamp() + ", integration=" + this.getIntegration() + ")";
    }

    public static class EventsContextBuilder {
        private boolean enabledForAccount;
        private boolean enabledForRequest;
        private String auctionId;
        private Long auctionTimestamp;
        private String integration;

        EventsContextBuilder() {
        }

        public EventsContextBuilder enabledForAccount(boolean enabledForAccount) {
            this.enabledForAccount = enabledForAccount;
            return this;
        }

        public EventsContextBuilder enabledForRequest(boolean enabledForRequest) {
            this.enabledForRequest = enabledForRequest;
            return this;
        }

        public EventsContextBuilder auctionId(String auctionId) {
            this.auctionId = auctionId;
            return this;
        }

        public EventsContextBuilder auctionTimestamp(Long auctionTimestamp) {
            this.auctionTimestamp = auctionTimestamp;
            return this;
        }

        public EventsContextBuilder integration(String integration) {
            this.integration = integration;
            return this;
        }

        public EventsContext build() {
            return new EventsContext(this.enabledForAccount, this.enabledForRequest, this.auctionId, this.auctionTimestamp, this.integration);
        }

        public String toString() {
            return "EventsContext.EventsContextBuilder(enabledForAccount=" + this.enabledForAccount + ", enabledForRequest=" + this.enabledForRequest + ", auctionId=" + this.auctionId + ", auctionTimestamp=" + this.auctionTimestamp + ", integration=" + this.integration + ")";
        }
    }
}

