/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals.targeting.interpret;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.deals.targeting.RequestContext;
import org.prebid.server.deals.targeting.interpret.In;
import org.prebid.server.deals.targeting.model.LookupResult;
import org.prebid.server.deals.targeting.syntax.TargetingCategory;

public class InStrings
extends In<String> {
    public InStrings(TargetingCategory category, List<String> values) {
        super(category, InStrings.toLowerCase(values));
    }

    @Override
    public LookupResult<String> lookupActualValue(RequestContext context) {
        List<String> actualValue = InStrings.firstNonEmpty(() -> context.lookupString(this.category).getValues(), () -> this.lookupIntegerAsString(context));
        return actualValue != null ? LookupResult.of(actualValue.stream().map(String::toLowerCase).toList()) : LookupResult.empty();
    }

    private List<String> lookupIntegerAsString(RequestContext context) {
        List<Integer> actualValue = context.lookupInteger(this.category).getValues();
        return actualValue.stream().map(Object::toString).toList();
    }

    private static List<String> toLowerCase(List<String> values) {
        return values.stream().map(String::toLowerCase).toList();
    }

    @SafeVarargs
    private static List<String> firstNonEmpty(Supplier<List<String>> ... suppliers) {
        return Stream.of(suppliers).map(Supplier::get).filter(CollectionUtils::isNotEmpty).findFirst().orElse(null);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InStrings)) {
            return false;
        }
        InStrings other = (InStrings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InStrings;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

