/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals.simulation;

import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.Map;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.deals.DeliveryProgressReportFactory;
import org.prebid.server.deals.DeliveryProgressService;
import org.prebid.server.deals.DeliveryStatsService;
import org.prebid.server.deals.LineItemService;
import org.prebid.server.deals.lineitem.LineItem;
import org.prebid.server.deals.model.DeliveryProgressProperties;
import org.prebid.server.log.CriteriaLogManager;
import org.prebid.server.util.HttpUtil;

public class SimulationAwareDeliveryProgressService
extends DeliveryProgressService {
    private static final String PG_SIM_TIMESTAMP = "pg-sim-timestamp";
    private final long readyAtAdjustment;
    private volatile boolean firstReportUpdate;

    public SimulationAwareDeliveryProgressService(DeliveryProgressProperties deliveryProgressProperties, LineItemService lineItemService, DeliveryStatsService deliveryStatsService, DeliveryProgressReportFactory deliveryProgressReportFactory, long readyAtAdjustment, Clock clock, CriteriaLogManager criteriaLogManager) {
        super(deliveryProgressProperties, lineItemService, deliveryStatsService, deliveryProgressReportFactory, clock, criteriaLogManager);
        this.readyAtAdjustment = readyAtAdjustment;
        this.firstReportUpdate = true;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void processAuctionEvent(AuctionContext auctionContext) {
        ZonedDateTime now = HttpUtil.getDateFromHeader(auctionContext.getHttpRequest().getHeaders(), PG_SIM_TIMESTAMP);
        if (this.firstReportUpdate) {
            this.firstReportUpdate = false;
            this.updateDeliveryProgressesStartTime(now);
        }
        super.processAuctionEvent(auctionContext.getTxnLog(), auctionContext.getAccount().getId(), now);
    }

    @Override
    protected void incrementTokens(LineItem lineItem, ZonedDateTime now, Map<String, Integer> planIdToTokenPriority) {
        Integer classPriority = lineItem.incSpentToken(now, this.readyAtAdjustment);
        if (classPriority != null) {
            planIdToTokenPriority.put(lineItem.getActiveDeliveryPlan().getPlanId(), classPriority);
        }
    }

    private void updateDeliveryProgressesStartTime(ZonedDateTime now) {
        this.overallDeliveryProgress.setStartTimeStamp(now);
        this.currentDeliveryProgress.setStartTimeStamp(now);
    }

    void createDeliveryProgressReport(ZonedDateTime now) {
        this.createDeliveryProgressReports(now);
    }
}

