/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;
import java.util.List;
import org.prebid.server.deals.model.UserId;
import org.prebid.server.deals.proto.FrequencyCap;

public final class WinEventNotification {
    @JsonProperty(value="bidderCode")
    private final String bidderCode;
    @JsonProperty(value="bidId")
    private final String bidId;
    @JsonProperty(value="lineItemId")
    private final String lineItemId;
    private final String region;
    @JsonProperty(value="userIds")
    private final List<UserId> userIds;
    @JsonProperty(value="winEventDateTime")
    private final ZonedDateTime winEventDateTime;
    @JsonProperty(value="lineUpdatedDateTime")
    private final ZonedDateTime lineUpdatedDateTime;
    @JsonProperty(value="frequencyCaps")
    private final List<FrequencyCap> frequencyCaps;

    @ConstructorProperties(value={"bidderCode", "bidId", "lineItemId", "region", "userIds", "winEventDateTime", "lineUpdatedDateTime", "frequencyCaps"})
    WinEventNotification(String bidderCode, String bidId, String lineItemId, String region, List<UserId> userIds, ZonedDateTime winEventDateTime, ZonedDateTime lineUpdatedDateTime, List<FrequencyCap> frequencyCaps) {
        this.bidderCode = bidderCode;
        this.bidId = bidId;
        this.lineItemId = lineItemId;
        this.region = region;
        this.userIds = userIds;
        this.winEventDateTime = winEventDateTime;
        this.lineUpdatedDateTime = lineUpdatedDateTime;
        this.frequencyCaps = frequencyCaps;
    }

    public static WinEventNotificationBuilder builder() {
        return new WinEventNotificationBuilder();
    }

    public WinEventNotificationBuilder toBuilder() {
        return new WinEventNotificationBuilder().bidderCode(this.bidderCode).bidId(this.bidId).lineItemId(this.lineItemId).region(this.region).userIds(this.userIds).winEventDateTime(this.winEventDateTime).lineUpdatedDateTime(this.lineUpdatedDateTime).frequencyCaps(this.frequencyCaps);
    }

    public String getBidderCode() {
        return this.bidderCode;
    }

    public String getBidId() {
        return this.bidId;
    }

    public String getLineItemId() {
        return this.lineItemId;
    }

    public String getRegion() {
        return this.region;
    }

    public List<UserId> getUserIds() {
        return this.userIds;
    }

    public ZonedDateTime getWinEventDateTime() {
        return this.winEventDateTime;
    }

    public ZonedDateTime getLineUpdatedDateTime() {
        return this.lineUpdatedDateTime;
    }

    public List<FrequencyCap> getFrequencyCaps() {
        return this.frequencyCaps;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WinEventNotification)) {
            return false;
        }
        WinEventNotification other = (WinEventNotification)o;
        String this$bidderCode = this.getBidderCode();
        String other$bidderCode = other.getBidderCode();
        if (this$bidderCode == null ? other$bidderCode != null : !this$bidderCode.equals(other$bidderCode)) {
            return false;
        }
        String this$bidId = this.getBidId();
        String other$bidId = other.getBidId();
        if (this$bidId == null ? other$bidId != null : !this$bidId.equals(other$bidId)) {
            return false;
        }
        String this$lineItemId = this.getLineItemId();
        String other$lineItemId = other.getLineItemId();
        if (this$lineItemId == null ? other$lineItemId != null : !this$lineItemId.equals(other$lineItemId)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        List<UserId> this$userIds = this.getUserIds();
        List<UserId> other$userIds = other.getUserIds();
        if (this$userIds == null ? other$userIds != null : !((Object)this$userIds).equals(other$userIds)) {
            return false;
        }
        ZonedDateTime this$winEventDateTime = this.getWinEventDateTime();
        ZonedDateTime other$winEventDateTime = other.getWinEventDateTime();
        if (this$winEventDateTime == null ? other$winEventDateTime != null : !((Object)this$winEventDateTime).equals(other$winEventDateTime)) {
            return false;
        }
        ZonedDateTime this$lineUpdatedDateTime = this.getLineUpdatedDateTime();
        ZonedDateTime other$lineUpdatedDateTime = other.getLineUpdatedDateTime();
        if (this$lineUpdatedDateTime == null ? other$lineUpdatedDateTime != null : !((Object)this$lineUpdatedDateTime).equals(other$lineUpdatedDateTime)) {
            return false;
        }
        List<FrequencyCap> this$frequencyCaps = this.getFrequencyCaps();
        List<FrequencyCap> other$frequencyCaps = other.getFrequencyCaps();
        return !(this$frequencyCaps == null ? other$frequencyCaps != null : !((Object)this$frequencyCaps).equals(other$frequencyCaps));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $bidderCode = this.getBidderCode();
        result = result * 59 + ($bidderCode == null ? 43 : $bidderCode.hashCode());
        String $bidId = this.getBidId();
        result = result * 59 + ($bidId == null ? 43 : $bidId.hashCode());
        String $lineItemId = this.getLineItemId();
        result = result * 59 + ($lineItemId == null ? 43 : $lineItemId.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        List<UserId> $userIds = this.getUserIds();
        result = result * 59 + ($userIds == null ? 43 : ((Object)$userIds).hashCode());
        ZonedDateTime $winEventDateTime = this.getWinEventDateTime();
        result = result * 59 + ($winEventDateTime == null ? 43 : ((Object)$winEventDateTime).hashCode());
        ZonedDateTime $lineUpdatedDateTime = this.getLineUpdatedDateTime();
        result = result * 59 + ($lineUpdatedDateTime == null ? 43 : ((Object)$lineUpdatedDateTime).hashCode());
        List<FrequencyCap> $frequencyCaps = this.getFrequencyCaps();
        result = result * 59 + ($frequencyCaps == null ? 43 : ((Object)$frequencyCaps).hashCode());
        return result;
    }

    public String toString() {
        return "WinEventNotification(bidderCode=" + this.getBidderCode() + ", bidId=" + this.getBidId() + ", lineItemId=" + this.getLineItemId() + ", region=" + this.getRegion() + ", userIds=" + this.getUserIds() + ", winEventDateTime=" + this.getWinEventDateTime() + ", lineUpdatedDateTime=" + this.getLineUpdatedDateTime() + ", frequencyCaps=" + this.getFrequencyCaps() + ")";
    }

    public static class WinEventNotificationBuilder {
        private String bidderCode;
        private String bidId;
        private String lineItemId;
        private String region;
        private List<UserId> userIds;
        private ZonedDateTime winEventDateTime;
        private ZonedDateTime lineUpdatedDateTime;
        private List<FrequencyCap> frequencyCaps;

        WinEventNotificationBuilder() {
        }

        @JsonProperty(value="bidderCode")
        public WinEventNotificationBuilder bidderCode(String bidderCode) {
            this.bidderCode = bidderCode;
            return this;
        }

        @JsonProperty(value="bidId")
        public WinEventNotificationBuilder bidId(String bidId) {
            this.bidId = bidId;
            return this;
        }

        @JsonProperty(value="lineItemId")
        public WinEventNotificationBuilder lineItemId(String lineItemId) {
            this.lineItemId = lineItemId;
            return this;
        }

        public WinEventNotificationBuilder region(String region) {
            this.region = region;
            return this;
        }

        @JsonProperty(value="userIds")
        public WinEventNotificationBuilder userIds(List<UserId> userIds) {
            this.userIds = userIds;
            return this;
        }

        @JsonProperty(value="winEventDateTime")
        public WinEventNotificationBuilder winEventDateTime(ZonedDateTime winEventDateTime) {
            this.winEventDateTime = winEventDateTime;
            return this;
        }

        @JsonProperty(value="lineUpdatedDateTime")
        public WinEventNotificationBuilder lineUpdatedDateTime(ZonedDateTime lineUpdatedDateTime) {
            this.lineUpdatedDateTime = lineUpdatedDateTime;
            return this;
        }

        @JsonProperty(value="frequencyCaps")
        public WinEventNotificationBuilder frequencyCaps(List<FrequencyCap> frequencyCaps) {
            this.frequencyCaps = frequencyCaps;
            return this;
        }

        public WinEventNotification build() {
            return new WinEventNotification(this.bidderCode, this.bidId, this.lineItemId, this.region, this.userIds, this.winEventDateTime, this.lineUpdatedDateTime, this.frequencyCaps);
        }

        public String toString() {
            return "WinEventNotification.WinEventNotificationBuilder(bidderCode=" + this.bidderCode + ", bidId=" + this.bidId + ", lineItemId=" + this.lineItemId + ", region=" + this.region + ", userIds=" + this.userIds + ", winEventDateTime=" + this.winEventDateTime + ", lineUpdatedDateTime=" + this.lineUpdatedDateTime + ", frequencyCaps=" + this.frequencyCaps + ")";
        }
    }
}

