/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals.model;

import java.beans.ConstructorProperties;
import lombok.NonNull;

public final class DeliveryStatsProperties {
    @NonNull
    private final String endpoint;
    private final int cachedReportsNumber;
    private final long timeoutMs;
    private final int lineItemsPerReport;
    private final int reportsIntervalMs;
    private final int batchesIntervalMs;
    private final boolean requestCompressionEnabled;
    @NonNull
    private final String username;
    @NonNull
    private final String password;

    @ConstructorProperties(value={"endpoint", "cachedReportsNumber", "timeoutMs", "lineItemsPerReport", "reportsIntervalMs", "batchesIntervalMs", "requestCompressionEnabled", "username", "password"})
    DeliveryStatsProperties(@NonNull String endpoint, int cachedReportsNumber, long timeoutMs, int lineItemsPerReport, int reportsIntervalMs, int batchesIntervalMs, boolean requestCompressionEnabled, @NonNull String username, @NonNull String password) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        this.endpoint = endpoint;
        this.cachedReportsNumber = cachedReportsNumber;
        this.timeoutMs = timeoutMs;
        this.lineItemsPerReport = lineItemsPerReport;
        this.reportsIntervalMs = reportsIntervalMs;
        this.batchesIntervalMs = batchesIntervalMs;
        this.requestCompressionEnabled = requestCompressionEnabled;
        this.username = username;
        this.password = password;
    }

    public static DeliveryStatsPropertiesBuilder builder() {
        return new DeliveryStatsPropertiesBuilder();
    }

    @NonNull
    public String getEndpoint() {
        return this.endpoint;
    }

    public int getCachedReportsNumber() {
        return this.cachedReportsNumber;
    }

    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    public int getLineItemsPerReport() {
        return this.lineItemsPerReport;
    }

    public int getReportsIntervalMs() {
        return this.reportsIntervalMs;
    }

    public int getBatchesIntervalMs() {
        return this.batchesIntervalMs;
    }

    public boolean isRequestCompressionEnabled() {
        return this.requestCompressionEnabled;
    }

    @NonNull
    public String getUsername() {
        return this.username;
    }

    @NonNull
    public String getPassword() {
        return this.password;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeliveryStatsProperties)) {
            return false;
        }
        DeliveryStatsProperties other = (DeliveryStatsProperties)o;
        if (this.getCachedReportsNumber() != other.getCachedReportsNumber()) {
            return false;
        }
        if (this.getTimeoutMs() != other.getTimeoutMs()) {
            return false;
        }
        if (this.getLineItemsPerReport() != other.getLineItemsPerReport()) {
            return false;
        }
        if (this.getReportsIntervalMs() != other.getReportsIntervalMs()) {
            return false;
        }
        if (this.getBatchesIntervalMs() != other.getBatchesIntervalMs()) {
            return false;
        }
        if (this.isRequestCompressionEnabled() != other.isRequestCompressionEnabled()) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCachedReportsNumber();
        long $timeoutMs = this.getTimeoutMs();
        result = result * 59 + (int)($timeoutMs >>> 32 ^ $timeoutMs);
        result = result * 59 + this.getLineItemsPerReport();
        result = result * 59 + this.getReportsIntervalMs();
        result = result * 59 + this.getBatchesIntervalMs();
        result = result * 59 + (this.isRequestCompressionEnabled() ? 79 : 97);
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "DeliveryStatsProperties(endpoint=" + this.getEndpoint() + ", cachedReportsNumber=" + this.getCachedReportsNumber() + ", timeoutMs=" + this.getTimeoutMs() + ", lineItemsPerReport=" + this.getLineItemsPerReport() + ", reportsIntervalMs=" + this.getReportsIntervalMs() + ", batchesIntervalMs=" + this.getBatchesIntervalMs() + ", requestCompressionEnabled=" + this.isRequestCompressionEnabled() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
    }

    public static class DeliveryStatsPropertiesBuilder {
        private String endpoint;
        private int cachedReportsNumber;
        private long timeoutMs;
        private int lineItemsPerReport;
        private int reportsIntervalMs;
        private int batchesIntervalMs;
        private boolean requestCompressionEnabled;
        private String username;
        private String password;

        DeliveryStatsPropertiesBuilder() {
        }

        public DeliveryStatsPropertiesBuilder endpoint(@NonNull String endpoint) {
            if (endpoint == null) {
                throw new NullPointerException("endpoint is marked non-null but is null");
            }
            this.endpoint = endpoint;
            return this;
        }

        public DeliveryStatsPropertiesBuilder cachedReportsNumber(int cachedReportsNumber) {
            this.cachedReportsNumber = cachedReportsNumber;
            return this;
        }

        public DeliveryStatsPropertiesBuilder timeoutMs(long timeoutMs) {
            this.timeoutMs = timeoutMs;
            return this;
        }

        public DeliveryStatsPropertiesBuilder lineItemsPerReport(int lineItemsPerReport) {
            this.lineItemsPerReport = lineItemsPerReport;
            return this;
        }

        public DeliveryStatsPropertiesBuilder reportsIntervalMs(int reportsIntervalMs) {
            this.reportsIntervalMs = reportsIntervalMs;
            return this;
        }

        public DeliveryStatsPropertiesBuilder batchesIntervalMs(int batchesIntervalMs) {
            this.batchesIntervalMs = batchesIntervalMs;
            return this;
        }

        public DeliveryStatsPropertiesBuilder requestCompressionEnabled(boolean requestCompressionEnabled) {
            this.requestCompressionEnabled = requestCompressionEnabled;
            return this;
        }

        public DeliveryStatsPropertiesBuilder username(@NonNull String username) {
            if (username == null) {
                throw new NullPointerException("username is marked non-null but is null");
            }
            this.username = username;
            return this;
        }

        public DeliveryStatsPropertiesBuilder password(@NonNull String password) {
            if (password == null) {
                throw new NullPointerException("password is marked non-null but is null");
            }
            this.password = password;
            return this;
        }

        public DeliveryStatsProperties build() {
            return new DeliveryStatsProperties(this.endpoint, this.cachedReportsNumber, this.timeoutMs, this.lineItemsPerReport, this.reportsIntervalMs, this.batchesIntervalMs, this.requestCompressionEnabled, this.username, this.password);
        }

        public String toString() {
            return "DeliveryStatsProperties.DeliveryStatsPropertiesBuilder(endpoint=" + this.endpoint + ", cachedReportsNumber=" + this.cachedReportsNumber + ", timeoutMs=" + this.timeoutMs + ", lineItemsPerReport=" + this.lineItemsPerReport + ", reportsIntervalMs=" + this.reportsIntervalMs + ", batchesIntervalMs=" + this.batchesIntervalMs + ", requestCompressionEnabled=" + this.requestCompressionEnabled + ", username=" + this.username + ", password=" + this.password + ")";
        }
    }
}

