/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals.events;

import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.EventBus;
import java.util.Objects;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.vertx.LocalMessageCodec;

public class ApplicationEventService {
    private static final String ADDRESS_EVENT_OPENRTB2_AUCTION = "event.openrtb2-auction";
    private static final String ADDRESS_EVENT_LINE_ITEM_WIN = "event.line-item-win";
    private static final String ADDRESS_EVENT_DELIVERY_UPDATE = "event.delivery-update";
    private static final DeliveryOptions DELIVERY_OPTIONS = new DeliveryOptions().setCodecName(LocalMessageCodec.codecName());
    private final EventBus eventBus;

    public ApplicationEventService(EventBus eventBus) {
        this.eventBus = Objects.requireNonNull(eventBus);
    }

    public void publishAuctionEvent(AuctionContext auctionContext) {
        this.eventBus.publish(ADDRESS_EVENT_OPENRTB2_AUCTION, (Object)auctionContext, DELIVERY_OPTIONS);
    }

    public void publishLineItemWinEvent(String lineItemId) {
        this.eventBus.publish(ADDRESS_EVENT_LINE_ITEM_WIN, (Object)lineItemId);
    }

    public void publishDeliveryUpdateEvent() {
        this.eventBus.publish(ADDRESS_EVENT_DELIVERY_UPDATE, null);
    }
}

