/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.deals.targeting.RequestContext;
import org.prebid.server.deals.targeting.TargetingDefinition;
import org.prebid.server.deals.targeting.interpret.And;
import org.prebid.server.deals.targeting.interpret.DomainMetricAwareExpression;
import org.prebid.server.deals.targeting.interpret.Expression;
import org.prebid.server.deals.targeting.interpret.InIntegers;
import org.prebid.server.deals.targeting.interpret.InStrings;
import org.prebid.server.deals.targeting.interpret.IntersectsIntegers;
import org.prebid.server.deals.targeting.interpret.IntersectsSizes;
import org.prebid.server.deals.targeting.interpret.IntersectsStrings;
import org.prebid.server.deals.targeting.interpret.Matches;
import org.prebid.server.deals.targeting.interpret.Not;
import org.prebid.server.deals.targeting.interpret.Or;
import org.prebid.server.deals.targeting.interpret.Within;
import org.prebid.server.deals.targeting.model.GeoRegion;
import org.prebid.server.deals.targeting.model.Size;
import org.prebid.server.deals.targeting.syntax.BooleanOperator;
import org.prebid.server.deals.targeting.syntax.MatchingFunction;
import org.prebid.server.deals.targeting.syntax.TargetingCategory;
import org.prebid.server.exception.TargetingSyntaxException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.util.StreamUtil;

public class TargetingService {
    private final JacksonMapper mapper;

    public TargetingService(JacksonMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper);
    }

    public TargetingDefinition parseTargetingDefinition(JsonNode targetingDefinition, String lineItemId) {
        return TargetingDefinition.of(this.parseNode(targetingDefinition, lineItemId));
    }

    public boolean matchesTargeting(BidRequest bidRequest, Imp imp, TargetingDefinition targetingDefinition, AuctionContext auctionContext) {
        RequestContext requestContext = new RequestContext(bidRequest, imp, auctionContext.getTxnLog(), this.mapper);
        return targetingDefinition.getRootExpression().matches(requestContext);
    }

    private Expression parseNode(JsonNode node, String lineItemId) {
        Map.Entry<String, JsonNode> field = TargetingService.validateIsSingleElementObject(node);
        String fieldName = field.getKey();
        if (BooleanOperator.isBooleanOperator(fieldName)) {
            return this.parseBooleanOperator(fieldName, field.getValue(), lineItemId);
        }
        if (TargetingCategory.isTargetingCategory(fieldName)) {
            return this.parseTargetingCategory(fieldName, field.getValue(), lineItemId);
        }
        throw new TargetingSyntaxException("Expected either boolean operator or targeting category, got " + fieldName);
    }

    private Expression parseBooleanOperator(String fieldName, JsonNode value, String lineItemId) {
        BooleanOperator operator = BooleanOperator.fromString(fieldName);
        return switch (operator) {
            default -> throw new IncompatibleClassChangeError();
            case BooleanOperator.AND -> new And(TargetingService.parseArray(value, node -> this.parseNode((JsonNode)node, lineItemId)));
            case BooleanOperator.OR -> new Or(TargetingService.parseArray(value, node -> this.parseNode((JsonNode)node, lineItemId)));
            case BooleanOperator.NOT -> new Not(this.parseNode(value, lineItemId));
        };
    }

    private Expression parseTargetingCategory(String fieldName, JsonNode value, String lineItemId) {
        TargetingCategory category = TargetingCategory.fromString(fieldName);
        return switch (category.type()) {
            default -> throw new IncompatibleClassChangeError();
            case TargetingCategory.Type.size -> new IntersectsSizes(category, TargetingService.parseArrayFunction(value, MatchingFunction.INTERSECTS, this::parseSize));
            case TargetingCategory.Type.mediaType, TargetingCategory.Type.userSegment -> new IntersectsStrings(category, TargetingService.parseArrayFunction(value, MatchingFunction.INTERSECTS, TargetingService::parseString));
            case TargetingCategory.Type.domain -> TargetingService.prepareDomainExpression(category, value, lineItemId);
            case TargetingCategory.Type.publisherDomain -> new DomainMetricAwareExpression(TargetingService.parseStringFunction(category, value), lineItemId);
            case TargetingCategory.Type.referrer, TargetingCategory.Type.appBundle, TargetingCategory.Type.adslot -> TargetingService.parseStringFunction(category, value);
            case TargetingCategory.Type.pagePosition, TargetingCategory.Type.dow, TargetingCategory.Type.hour -> new InIntegers(category, TargetingService.parseArrayFunction(value, MatchingFunction.IN, TargetingService::parseInteger));
            case TargetingCategory.Type.deviceGeoExt, TargetingCategory.Type.deviceExt -> new InStrings(category, TargetingService.parseArrayFunction(value, MatchingFunction.IN, TargetingService::parseString));
            case TargetingCategory.Type.location -> new Within(category, TargetingService.parseSingleObjectFunction(value, MatchingFunction.WITHIN, this::parseGeoRegion));
            case TargetingCategory.Type.bidderParam, TargetingCategory.Type.userFirstPartyData, TargetingCategory.Type.siteFirstPartyData -> TargetingService.parseTypedFunction(category, value);
        };
    }

    private static Or prepareDomainExpression(TargetingCategory category, JsonNode value, String lineItemId) {
        DomainMetricAwareExpression domainExpression = new DomainMetricAwareExpression(TargetingService.parseStringFunction(category, value), lineItemId);
        TargetingCategory publisherDomainCategory = new TargetingCategory(TargetingCategory.Type.publisherDomain);
        DomainMetricAwareExpression publisherDomainExpression = new DomainMetricAwareExpression(TargetingService.parseStringFunction(publisherDomainCategory, value), lineItemId);
        return new Or(List.of(domainExpression, publisherDomainExpression));
    }

    private static <T> List<T> parseArrayFunction(JsonNode value, MatchingFunction function, Function<JsonNode, T> mapper) {
        return TargetingService.parseArray(TargetingService.validateIsFunction(value, function), mapper);
    }

    private static <T> T parseSingleObjectFunction(JsonNode value, MatchingFunction function, Function<JsonNode, T> mapper) {
        return mapper.apply(TargetingService.validateIsFunction(value, function));
    }

    private static Expression parseStringFunction(TargetingCategory category, JsonNode value) {
        Map.Entry<String, JsonNode> field = TargetingService.validateIsSingleElementObject(value);
        MatchingFunction function = TargetingService.validateCompatibleFunction(field, MatchingFunction.MATCHES, MatchingFunction.IN);
        return switch (function) {
            case MatchingFunction.MATCHES -> new Matches(category, TargetingService.parseString(field.getValue()));
            case MatchingFunction.IN -> TargetingService.createInStringsFunction(category, field.getValue());
            default -> throw new IllegalStateException("Unexpected string function " + function.value());
        };
    }

    private static Expression parseTypedFunction(TargetingCategory category, JsonNode value) {
        Map.Entry<String, JsonNode> field = TargetingService.validateIsSingleElementObject(value);
        MatchingFunction function = TargetingService.validateCompatibleFunction(field, MatchingFunction.MATCHES, MatchingFunction.IN, MatchingFunction.INTERSECTS);
        JsonNode functionValue = field.getValue();
        return switch (function) {
            case MatchingFunction.MATCHES -> new Matches(category, TargetingService.parseString(functionValue));
            case MatchingFunction.IN -> TargetingService.parseTypedInFunction(category, functionValue);
            case MatchingFunction.INTERSECTS -> TargetingService.parseTypedIntersectsFunction(category, functionValue);
            default -> throw new IllegalStateException("Unexpected typed function " + function.value());
        };
    }

    private Size parseSize(JsonNode node) {
        Size size;
        TargetingService.validateIsObject(node);
        try {
            size = (Size)this.mapper.mapper().treeToValue((TreeNode)node, Size.class);
        }
        catch (JsonProcessingException e) {
            throw new TargetingSyntaxException("Exception occurred while parsing size: " + e.getMessage(), e);
        }
        if (size.getH() == null || size.getW() == null) {
            throw new TargetingSyntaxException("Height and width in size definition could not be null or missing");
        }
        return size;
    }

    private static String parseString(JsonNode node) {
        TargetingService.validateIsString(node);
        String value = node.textValue();
        if (StringUtils.isEmpty((CharSequence)value)) {
            throw new TargetingSyntaxException("String value could not be empty");
        }
        return value;
    }

    private static Integer parseInteger(JsonNode node) {
        TargetingService.validateIsInteger(node);
        return node.intValue();
    }

    private GeoRegion parseGeoRegion(JsonNode node) {
        GeoRegion region;
        TargetingService.validateIsObject(node);
        try {
            region = (GeoRegion)this.mapper.mapper().treeToValue((TreeNode)node, GeoRegion.class);
        }
        catch (JsonProcessingException e) {
            throw new TargetingSyntaxException("Exception occurred while parsing geo region: " + e.getMessage(), e);
        }
        if (region.getLat() == null || region.getLon() == null || region.getRadiusMiles() == null) {
            throw new TargetingSyntaxException("Lat, lon and radiusMiles in geo region definition could not be null or missing");
        }
        return region;
    }

    private static <T> List<T> parseArray(JsonNode node, Function<JsonNode, T> mapper) {
        TargetingService.validateIsArray(node);
        return StreamUtil.asStream(node.spliterator()).map(mapper).toList();
    }

    private static Expression parseTypedInFunction(TargetingCategory category, JsonNode value) {
        return TargetingService.parseTypedArrayFunction(category, value, TargetingService::createInIntegersFunction, TargetingService::createInStringsFunction);
    }

    private static Expression parseTypedIntersectsFunction(TargetingCategory category, JsonNode value) {
        return TargetingService.parseTypedArrayFunction(category, value, TargetingService::createIntersectsIntegersFunction, TargetingService::createIntersectsStringsFunction);
    }

    private static Expression parseTypedArrayFunction(TargetingCategory category, JsonNode value, BiFunction<TargetingCategory, JsonNode, Expression> integerCreator, BiFunction<TargetingCategory, JsonNode, Expression> stringCreator) {
        TargetingService.validateIsArray(value);
        Iterator iterator = value.iterator();
        JsonNodeType dataType = iterator.hasNext() ? ((JsonNode)iterator.next()).getNodeType() : JsonNodeType.STRING;
        return switch (dataType) {
            case JsonNodeType.NUMBER -> integerCreator.apply(category, value);
            case JsonNodeType.STRING -> stringCreator.apply(category, value);
            default -> throw new TargetingSyntaxException("Expected integer or string, got " + dataType);
        };
    }

    private static Expression createInIntegersFunction(TargetingCategory category, JsonNode value) {
        return new InIntegers(category, TargetingService.parseArray(value, TargetingService::parseInteger));
    }

    private static InStrings createInStringsFunction(TargetingCategory category, JsonNode value) {
        return new InStrings(category, TargetingService.parseArray(value, TargetingService::parseString));
    }

    private static Expression createIntersectsStringsFunction(TargetingCategory category, JsonNode value) {
        return new IntersectsStrings(category, TargetingService.parseArray(value, TargetingService::parseString));
    }

    private static Expression createIntersectsIntegersFunction(TargetingCategory category, JsonNode value) {
        return new IntersectsIntegers(category, TargetingService.parseArray(value, TargetingService::parseInteger));
    }

    private static void validateIsObject(JsonNode value) {
        if (!value.isObject()) {
            throw new TargetingSyntaxException("Expected object, got " + value.getNodeType());
        }
    }

    private static Map.Entry<String, JsonNode> validateIsSingleElementObject(JsonNode value) {
        TargetingService.validateIsObject(value);
        if (value.size() != 1) {
            throw new TargetingSyntaxException("Expected only one element in the object, got " + value.size());
        }
        return (Map.Entry)value.fields().next();
    }

    private static void validateIsArray(JsonNode value) {
        if (!value.isArray()) {
            throw new TargetingSyntaxException("Expected array, got " + value.getNodeType());
        }
    }

    private static void validateIsString(JsonNode value) {
        if (!value.isTextual()) {
            throw new TargetingSyntaxException("Expected string, got " + value.getNodeType());
        }
    }

    private static void validateIsInteger(JsonNode value) {
        if (!value.isInt()) {
            throw new TargetingSyntaxException("Expected integer, got " + value.getNodeType());
        }
    }

    private static JsonNode validateIsFunction(JsonNode value, MatchingFunction function) {
        Map.Entry<String, JsonNode> field = TargetingService.validateIsSingleElementObject(value);
        String fieldName = field.getKey();
        if (!MatchingFunction.isMatchingFunction(fieldName)) {
            throw new TargetingSyntaxException("Expected matching function, got " + fieldName);
        }
        if (MatchingFunction.fromString(fieldName) != function) {
            throw new TargetingSyntaxException("Expected %s matching function, got %s".formatted(function.value(), fieldName));
        }
        return field.getValue();
    }

    private static MatchingFunction validateCompatibleFunction(Map.Entry<String, JsonNode> field, MatchingFunction ... compatibleFunctions) {
        String fieldName = field.getKey();
        if (!MatchingFunction.isMatchingFunction(fieldName)) {
            throw new TargetingSyntaxException("Expected matching function, got " + fieldName);
        }
        MatchingFunction function = MatchingFunction.fromString(fieldName);
        if (!Arrays.asList(compatibleFunctions).contains((Object)function)) {
            throw new TargetingSyntaxException("Expected one of %s matching functions, got %s".formatted(Arrays.stream(compatibleFunctions).map(MatchingFunction::value).collect(Collectors.joining(", ")), fieldName));
        }
        return function;
    }
}

