/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.cookie.model;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.SetUtils;
import org.prebid.server.bidder.UsersyncMethod;
import org.prebid.server.cookie.model.RejectionReason;

public final class BiddersContext {
    private final Set<String> requestedBidders;
    private final Set<String> coopSyncBidders;
    private final Set<String> multiSyncBidders;
    private final Map<String, RejectionReason> rejectedBidders;
    private final Map<String, UsersyncMethod> bidderUsersyncMethod;

    public boolean isRequested(String bidder) {
        return this.requestedBidders.contains(bidder);
    }

    public boolean isCoopSync(String bidder) {
        return this.coopSyncBidders.contains(bidder);
    }

    private Set<String> involvedBidders() {
        return SetUtils.union(this.multiSyncBidders, (Set)SetUtils.union(this.requestedBidders, this.coopSyncBidders));
    }

    public Set<String> allowedBidders() {
        return SetUtils.difference(this.involvedBidders(), this.rejectedBidders.keySet());
    }

    public Set<String> allowedRequestedBidders() {
        return SetUtils.difference(this.requestedBidders, this.rejectedBidders.keySet());
    }

    public Set<String> allowedCoopSyncBidders() {
        return SetUtils.difference(this.coopSyncBidders, this.rejectedBidders.keySet());
    }

    public Set<String> allowedMultisyncBidders() {
        return SetUtils.difference(this.multiSyncBidders, this.rejectedBidders.keySet());
    }

    public BiddersContext withRejectedBidder(String bidder, RejectionReason reason) {
        return this.withRejectedBidders(Collections.singleton(bidder), reason);
    }

    public BiddersContext withRejectedBidders(Collection<String> bidders, RejectionReason reason) {
        if (bidders.isEmpty()) {
            return this;
        }
        HashMap<String, RejectionReason> updatedRejectedBidders = new HashMap<String, RejectionReason>(this.rejectedBidders);
        HashMap<String, UsersyncMethod> updatedMethods = new HashMap<String, UsersyncMethod>(this.bidderUsersyncMethod);
        for (String bidder : bidders) {
            updatedRejectedBidders.put(bidder, reason);
            updatedMethods.remove(bidder);
        }
        return this.toBuilder().rejectedBidders(updatedRejectedBidders).bidderUsersyncMethod(updatedMethods).build();
    }

    public BiddersContext withBidderUsersyncMethod(String bidder, UsersyncMethod method) {
        if (this.rejectedBidders.containsKey(bidder)) {
            return this;
        }
        HashMap<String, UsersyncMethod> updatedMethods = new HashMap<String, UsersyncMethod>(this.bidderUsersyncMethod);
        updatedMethods.put(bidder, method);
        return this.toBuilder().bidderUsersyncMethod(updatedMethods).build();
    }

    private static Set<String> $default$requestedBidders() {
        return new HashSet<String>();
    }

    private static Set<String> $default$coopSyncBidders() {
        return new HashSet<String>();
    }

    private static Set<String> $default$multiSyncBidders() {
        return new HashSet<String>();
    }

    private static Map<String, RejectionReason> $default$rejectedBidders() {
        return new HashMap<String, RejectionReason>();
    }

    private static Map<String, UsersyncMethod> $default$bidderUsersyncMethod() {
        return new HashMap<String, UsersyncMethod>();
    }

    @ConstructorProperties(value={"requestedBidders", "coopSyncBidders", "multiSyncBidders", "rejectedBidders", "bidderUsersyncMethod"})
    BiddersContext(Set<String> requestedBidders, Set<String> coopSyncBidders, Set<String> multiSyncBidders, Map<String, RejectionReason> rejectedBidders, Map<String, UsersyncMethod> bidderUsersyncMethod) {
        this.requestedBidders = requestedBidders;
        this.coopSyncBidders = coopSyncBidders;
        this.multiSyncBidders = multiSyncBidders;
        this.rejectedBidders = rejectedBidders;
        this.bidderUsersyncMethod = bidderUsersyncMethod;
    }

    public static BiddersContextBuilder builder() {
        return new BiddersContextBuilder();
    }

    public BiddersContextBuilder toBuilder() {
        return new BiddersContextBuilder().requestedBidders(this.requestedBidders).coopSyncBidders(this.coopSyncBidders).multiSyncBidders(this.multiSyncBidders).rejectedBidders(this.rejectedBidders).bidderUsersyncMethod(this.bidderUsersyncMethod);
    }

    public Set<String> requestedBidders() {
        return this.requestedBidders;
    }

    public Set<String> coopSyncBidders() {
        return this.coopSyncBidders;
    }

    public Set<String> multiSyncBidders() {
        return this.multiSyncBidders;
    }

    public Map<String, RejectionReason> rejectedBidders() {
        return this.rejectedBidders;
    }

    public Map<String, UsersyncMethod> bidderUsersyncMethod() {
        return this.bidderUsersyncMethod;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BiddersContext)) {
            return false;
        }
        BiddersContext other = (BiddersContext)o;
        Set<String> this$requestedBidders = this.requestedBidders();
        Set<String> other$requestedBidders = other.requestedBidders();
        if (this$requestedBidders == null ? other$requestedBidders != null : !((Object)this$requestedBidders).equals(other$requestedBidders)) {
            return false;
        }
        Set<String> this$coopSyncBidders = this.coopSyncBidders();
        Set<String> other$coopSyncBidders = other.coopSyncBidders();
        if (this$coopSyncBidders == null ? other$coopSyncBidders != null : !((Object)this$coopSyncBidders).equals(other$coopSyncBidders)) {
            return false;
        }
        Set<String> this$multiSyncBidders = this.multiSyncBidders();
        Set<String> other$multiSyncBidders = other.multiSyncBidders();
        if (this$multiSyncBidders == null ? other$multiSyncBidders != null : !((Object)this$multiSyncBidders).equals(other$multiSyncBidders)) {
            return false;
        }
        Map<String, RejectionReason> this$rejectedBidders = this.rejectedBidders();
        Map<String, RejectionReason> other$rejectedBidders = other.rejectedBidders();
        if (this$rejectedBidders == null ? other$rejectedBidders != null : !((Object)this$rejectedBidders).equals(other$rejectedBidders)) {
            return false;
        }
        Map<String, UsersyncMethod> this$bidderUsersyncMethod = this.bidderUsersyncMethod();
        Map<String, UsersyncMethod> other$bidderUsersyncMethod = other.bidderUsersyncMethod();
        return !(this$bidderUsersyncMethod == null ? other$bidderUsersyncMethod != null : !((Object)this$bidderUsersyncMethod).equals(other$bidderUsersyncMethod));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $requestedBidders = this.requestedBidders();
        result = result * 59 + ($requestedBidders == null ? 43 : ((Object)$requestedBidders).hashCode());
        Set<String> $coopSyncBidders = this.coopSyncBidders();
        result = result * 59 + ($coopSyncBidders == null ? 43 : ((Object)$coopSyncBidders).hashCode());
        Set<String> $multiSyncBidders = this.multiSyncBidders();
        result = result * 59 + ($multiSyncBidders == null ? 43 : ((Object)$multiSyncBidders).hashCode());
        Map<String, RejectionReason> $rejectedBidders = this.rejectedBidders();
        result = result * 59 + ($rejectedBidders == null ? 43 : ((Object)$rejectedBidders).hashCode());
        Map<String, UsersyncMethod> $bidderUsersyncMethod = this.bidderUsersyncMethod();
        result = result * 59 + ($bidderUsersyncMethod == null ? 43 : ((Object)$bidderUsersyncMethod).hashCode());
        return result;
    }

    public String toString() {
        return "BiddersContext(requestedBidders=" + this.requestedBidders() + ", coopSyncBidders=" + this.coopSyncBidders() + ", multiSyncBidders=" + this.multiSyncBidders() + ", rejectedBidders=" + this.rejectedBidders() + ", bidderUsersyncMethod=" + this.bidderUsersyncMethod() + ")";
    }

    public static class BiddersContextBuilder {
        private boolean requestedBidders$set;
        private Set<String> requestedBidders$value;
        private boolean coopSyncBidders$set;
        private Set<String> coopSyncBidders$value;
        private boolean multiSyncBidders$set;
        private Set<String> multiSyncBidders$value;
        private boolean rejectedBidders$set;
        private Map<String, RejectionReason> rejectedBidders$value;
        private boolean bidderUsersyncMethod$set;
        private Map<String, UsersyncMethod> bidderUsersyncMethod$value;

        BiddersContextBuilder() {
        }

        public BiddersContextBuilder requestedBidders(Set<String> requestedBidders) {
            this.requestedBidders$value = requestedBidders;
            this.requestedBidders$set = true;
            return this;
        }

        public BiddersContextBuilder coopSyncBidders(Set<String> coopSyncBidders) {
            this.coopSyncBidders$value = coopSyncBidders;
            this.coopSyncBidders$set = true;
            return this;
        }

        public BiddersContextBuilder multiSyncBidders(Set<String> multiSyncBidders) {
            this.multiSyncBidders$value = multiSyncBidders;
            this.multiSyncBidders$set = true;
            return this;
        }

        public BiddersContextBuilder rejectedBidders(Map<String, RejectionReason> rejectedBidders) {
            this.rejectedBidders$value = rejectedBidders;
            this.rejectedBidders$set = true;
            return this;
        }

        public BiddersContextBuilder bidderUsersyncMethod(Map<String, UsersyncMethod> bidderUsersyncMethod) {
            this.bidderUsersyncMethod$value = bidderUsersyncMethod;
            this.bidderUsersyncMethod$set = true;
            return this;
        }

        public BiddersContext build() {
            Set<String> requestedBidders$value = this.requestedBidders$value;
            if (!this.requestedBidders$set) {
                requestedBidders$value = BiddersContext.$default$requestedBidders();
            }
            Set<String> coopSyncBidders$value = this.coopSyncBidders$value;
            if (!this.coopSyncBidders$set) {
                coopSyncBidders$value = BiddersContext.$default$coopSyncBidders();
            }
            Set<String> multiSyncBidders$value = this.multiSyncBidders$value;
            if (!this.multiSyncBidders$set) {
                multiSyncBidders$value = BiddersContext.$default$multiSyncBidders();
            }
            Map<String, RejectionReason> rejectedBidders$value = this.rejectedBidders$value;
            if (!this.rejectedBidders$set) {
                rejectedBidders$value = BiddersContext.$default$rejectedBidders();
            }
            Map<String, UsersyncMethod> bidderUsersyncMethod$value = this.bidderUsersyncMethod$value;
            if (!this.bidderUsersyncMethod$set) {
                bidderUsersyncMethod$value = BiddersContext.$default$bidderUsersyncMethod();
            }
            return new BiddersContext(requestedBidders$value, coopSyncBidders$value, multiSyncBidders$value, rejectedBidders$value, bidderUsersyncMethod$value);
        }

        public String toString() {
            return "BiddersContext.BiddersContextBuilder(requestedBidders$value=" + this.requestedBidders$value + ", coopSyncBidders$value=" + this.coopSyncBidders$value + ", multiSyncBidders$value=" + this.multiSyncBidders$value + ", rejectedBidders$value=" + this.rejectedBidders$value + ", bidderUsersyncMethod$value=" + this.bidderUsersyncMethod$value + ")";
        }
    }
}

