/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.yieldlab;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Geo;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Regs;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.User;
import com.iab.openrtb.response.Bid;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.bidder.yieldlab.model.YieldlabResponse;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtUser;
import org.prebid.server.proto.openrtb.ext.request.yieldlab.ExtImpYieldlab;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

public class YieldlabBidder
implements Bidder<Void> {
    private static final TypeReference<ExtPrebid<?, ExtImpYieldlab>> YIELDLAB_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpYieldlab>>(){};
    private static final String BID_CURRENCY = "EUR";
    private static final String AD_SLOT_ID_SEPARATOR = ",";
    private static final String AD_SIZE_SEPARATOR = "x";
    private static final String CREATIVE_ID = "%s%s%s";
    private static final String AD_SOURCE_BANNER = "<script src=\"%s\"></script>";
    private static final String AD_SOURCE_URL = "https://ad.yieldlab.net/d/%s/%s/%s?%s";
    private static final String VAST_MARKUP = "<VAST version=\"2.0\"><Ad id=\"%s\"><Wrapper>\n<AdSystem>Yieldlab</AdSystem>\n<VASTAdTagURI><![CDATA[ %s ]]></VASTAdTagURI>\n<Impression></Impression>\n<Creatives></Creatives>\n</Wrapper></Ad></VAST>";
    private final String endpointUrl;
    private final Clock clock;
    private final JacksonMapper mapper;

    public YieldlabBidder(String endpointUrl, Clock clock, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.clock = Objects.requireNonNull(clock);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<Void>>> makeHttpRequests(BidRequest request) {
        String uri;
        ExtImpYieldlab modifiedExtImp = this.constructExtImp(request.getImp());
        try {
            uri = this.makeUrl(modifiedExtImp, request);
        }
        catch (PreBidException e) {
            return Result.withError(BidderError.badInput(e.getMessage()));
        }
        return Result.withValue(HttpRequest.builder().method(HttpMethod.GET).uri(uri).headers(YieldlabBidder.resolveHeaders(request.getSite(), request.getDevice(), request.getUser())).build());
    }

    private ExtImpYieldlab constructExtImp(List<Imp> imps) {
        List<ExtImpYieldlab> extImps = this.collectImpExt(imps);
        List<String> adSlotIds = extImps.stream().map(ExtImpYieldlab::getAdslotId).filter(Objects::nonNull).toList();
        Map<String, String> targeting = extImps.stream().map(ExtImpYieldlab::getTargeting).filter(Objects::nonNull).flatMap(map -> map.entrySet().stream()).filter(entry -> entry.getKey() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (channel1, channel2) -> channel1));
        String adSlotIdsParams = adSlotIds.stream().sorted().collect(Collectors.joining(AD_SLOT_ID_SEPARATOR));
        return ExtImpYieldlab.builder().adslotId(adSlotIdsParams).targeting(targeting).build();
    }

    private List<ExtImpYieldlab> collectImpExt(List<Imp> imps) {
        ArrayList<ExtImpYieldlab> extImps = new ArrayList<ExtImpYieldlab>();
        for (Imp imp : imps) {
            ExtImpYieldlab extImpYieldlab = this.parseImpExt(imp);
            if (extImpYieldlab == null) continue;
            extImps.add(extImpYieldlab);
        }
        return extImps;
    }

    private ExtImpYieldlab parseImpExt(Imp imp) {
        try {
            return (ExtImpYieldlab)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), YIELDLAB_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private String makeUrl(ExtImpYieldlab extImpYieldlab, BidRequest request) {
        String consent;
        String gdpr;
        App app;
        Device device;
        URIBuilder uriBuilder;
        String timestamp = YieldlabBidder.isDebugEnabled(request) ? "200000" : String.valueOf(this.clock.instant().getEpochSecond());
        String updatedPath = "%s/%s".formatted(this.endpointUrl, extImpYieldlab.getAdslotId());
        try {
            uriBuilder = new URIBuilder(updatedPath);
        }
        catch (URISyntaxException e) {
            throw new PreBidException("Invalid url: %s, error: %s".formatted(updatedPath, e.getMessage()));
        }
        uriBuilder.addParameter("content", "json").addParameter("pvid", "true").addParameter("ts", timestamp).addParameter("t", this.getTargetingValues(extImpYieldlab));
        User user = request.getUser();
        if (user != null && StringUtils.isNotBlank((CharSequence)user.getBuyeruid())) {
            uriBuilder.addParameter("ids", String.join((CharSequence)"ylid:", user.getBuyeruid()));
        }
        if ((device = request.getDevice()) != null) {
            Geo geo;
            uriBuilder.addParameter("yl_rtb_ifa", device.getIfa());
            uriBuilder.addParameter("yl_rtb_devicetype", YieldlabBidder.resolveNumberParameter(device.getDevicetype()));
            Integer connectionType = device.getConnectiontype();
            if (connectionType != null) {
                uriBuilder.addParameter("yl_rtb_connectiontype", device.getConnectiontype().toString());
            }
            if ((geo = device.getGeo()) != null) {
                uriBuilder.addParameter("lat", YieldlabBidder.resolveNumberParameter(geo.getLat()));
                uriBuilder.addParameter("lon", YieldlabBidder.resolveNumberParameter(geo.getLon()));
            }
        }
        if ((app = request.getApp()) != null) {
            uriBuilder.addParameter("pubappname", app.getName()).addParameter("pubbundlename", app.getBundle());
        }
        if (StringUtils.isNotBlank((CharSequence)(gdpr = YieldlabBidder.getGdprParameter(request.getRegs())))) {
            uriBuilder.addParameter("gdpr", gdpr);
        }
        if (StringUtils.isNotBlank((CharSequence)(consent = YieldlabBidder.getConsentParameter(request.getUser())))) {
            uriBuilder.addParameter("consent", consent);
        }
        return uriBuilder.toString();
    }

    private static boolean isDebugEnabled(BidRequest bidRequest) {
        if (Objects.equals(bidRequest.getTest(), 1)) {
            return true;
        }
        ExtRequest extRequest = bidRequest.getExt();
        ExtRequestPrebid extRequestPrebid = extRequest != null ? extRequest.getPrebid() : null;
        return extRequestPrebid != null && Objects.equals(extRequestPrebid.getDebug(), 1);
    }

    private String getTargetingValues(ExtImpYieldlab extImpYieldlab) {
        URIBuilder uriBuilder = new URIBuilder();
        for (Map.Entry<String, String> targeting : extImpYieldlab.getTargeting().entrySet()) {
            uriBuilder.addParameter(targeting.getKey(), targeting.getValue());
        }
        return uriBuilder.toString().replace("?", "");
    }

    private static String getGdprParameter(Regs regs) {
        if (regs != null) {
            Integer gdpr;
            Integer n = gdpr = regs.getExt() != null ? regs.getExt().getGdpr() : null;
            if (gdpr != null && (gdpr == 0 || gdpr == 1)) {
                return gdpr.toString();
            }
        }
        return "";
    }

    private static String getConsentParameter(User user) {
        ExtUser extUser = user != null ? user.getExt() : null;
        String consent = extUser != null ? extUser.getConsent() : null;
        return (String)ObjectUtils.defaultIfNull((Object)consent, (Object)"");
    }

    private static MultiMap resolveHeaders(Site site, Device device, User user) {
        MultiMap headers = MultiMap.caseInsensitiveMultiMap().add(HttpUtil.ACCEPT_HEADER, (CharSequence)HttpHeaderValues.APPLICATION_JSON);
        if (site != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.REFERER_HEADER.toString(), site.getPage());
        }
        if (device != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.USER_AGENT_HEADER.toString(), device.getUa());
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.X_FORWARDED_FOR_HEADER.toString(), device.getIp());
        }
        if (user != null && StringUtils.isNotBlank((CharSequence)user.getBuyeruid())) {
            headers.add(HttpUtil.COOKIE_HEADER.toString(), "id=" + user.getBuyeruid());
        }
        return headers;
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<Void> httpCall, BidRequest bidRequest) {
        List<YieldlabResponse> yieldlabResponses;
        try {
            yieldlabResponses = this.decodeBodyToBidList(httpCall);
        }
        catch (PreBidException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
        ArrayList<BidderBid> bidderBids = new ArrayList<BidderBid>();
        for (int i = 0; i < yieldlabResponses.size(); ++i) {
            BidderBid bidderBid;
            try {
                bidderBid = this.resolveBidderBid(yieldlabResponses, i, bidRequest);
            }
            catch (PreBidException e) {
                return Result.withError(BidderError.badInput(e.getMessage()));
            }
            if (bidderBid == null) continue;
            bidderBids.add(bidderBid);
        }
        return Result.of(bidderBids, Collections.emptyList());
    }

    private BidderBid resolveBidderBid(List<YieldlabResponse> yieldlabResponses, int currentImpIndex, BidRequest bidRequest) {
        BidType bidType;
        YieldlabResponse yieldlabResponse = yieldlabResponses.get(currentImpIndex);
        ExtImpYieldlab matchedExtImp = this.getMatchedExtImp(yieldlabResponse.getId(), bidRequest.getImp());
        if (matchedExtImp == null) {
            throw new PreBidException("Invalid extension");
        }
        Imp currentImp = bidRequest.getImp().get(currentImpIndex);
        if (currentImp == null) {
            throw new PreBidException("Imp not present for id " + currentImpIndex);
        }
        Bid.BidBuilder updatedBid = Bid.builder();
        if (currentImp.getVideo() != null) {
            bidType = BidType.video;
            updatedBid.nurl(this.makeNurl(bidRequest, matchedExtImp, yieldlabResponse));
            updatedBid.adm(this.resolveAdm(bidRequest, matchedExtImp, yieldlabResponse));
        } else if (currentImp.getBanner() != null) {
            bidType = BidType.banner;
            updatedBid.adm(this.makeAdm(bidRequest, matchedExtImp, yieldlabResponse));
        } else {
            return null;
        }
        this.addBidParams(yieldlabResponse, bidRequest, updatedBid).impid(currentImp.getId());
        return BidderBid.of(updatedBid.build(), bidType, BID_CURRENCY);
    }

    private List<YieldlabResponse> decodeBodyToBidList(BidderCall<Void> httpCall) {
        try {
            return (List)this.mapper.mapper().readValue(httpCall.getResponse().getBody(), (JavaType)this.mapper.mapper().getTypeFactory().constructCollectionType(List.class, YieldlabResponse.class));
        }
        catch (JsonProcessingException | DecodeException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private ExtImpYieldlab getMatchedExtImp(Integer responseId, List<Imp> imps) {
        return this.collectImpExt(imps).stream().filter(ext -> ext.getAdslotId().equals(String.valueOf(responseId))).findFirst().orElse(null);
    }

    private Bid.BidBuilder addBidParams(YieldlabResponse yieldlabResponse, BidRequest bidRequest, Bid.BidBuilder updatedBid) {
        ExtImpYieldlab matchedExtImp = this.getMatchedExtImp(yieldlabResponse.getId(), bidRequest.getImp());
        if (matchedExtImp == null) {
            throw new PreBidException("Invalid extension");
        }
        updatedBid.id(YieldlabBidder.resolveNumberParameter(yieldlabResponse.getId())).price(YieldlabBidder.resolvePrice(yieldlabResponse.getPrice())).dealid(YieldlabBidder.resolveNumberParameter(yieldlabResponse.getPid())).crid(YieldlabBidder.makeCreativeId(bidRequest, yieldlabResponse, matchedExtImp)).w(YieldlabBidder.resolveSizeParameter(yieldlabResponse.getAdSize(), true)).h(YieldlabBidder.resolveSizeParameter(yieldlabResponse.getAdSize(), false));
        return updatedBid;
    }

    private static BigDecimal resolvePrice(Double price) {
        return price != null ? BigDecimal.valueOf(price / 100.0) : null;
    }

    private static String resolveNumberParameter(Number param) {
        return param != null ? String.valueOf(param) : null;
    }

    private static String makeCreativeId(BidRequest bidRequest, YieldlabResponse yieldlabResponse, ExtImpYieldlab extImp) {
        int weekNumber = YieldlabBidder.isDebugEnabled(bidRequest) ? 35 : Calendar.getInstance().get(3);
        return CREATIVE_ID.formatted(extImp.getAdslotId(), yieldlabResponse.getPid(), weekNumber);
    }

    private static Integer resolveSizeParameter(String adSize, boolean isWidth) {
        String[] sizeParts = adSize.split(AD_SIZE_SEPARATOR);
        if (sizeParts.length != 2) {
            return 0;
        }
        int sizeIndex = isWidth ? 0 : 1;
        return StringUtils.isNumeric((CharSequence)sizeParts[sizeIndex]) ? Integer.parseInt(sizeParts[sizeIndex]) : 0;
    }

    private String makeAdm(BidRequest bidRequest, ExtImpYieldlab extImpYieldlab, YieldlabResponse yieldlabResponse) {
        return AD_SOURCE_BANNER.formatted(this.makeNurl(bidRequest, extImpYieldlab, yieldlabResponse));
    }

    private String resolveAdm(BidRequest bidRequest, ExtImpYieldlab extImpYieldlab, YieldlabResponse yieldlabResponse) {
        return VAST_MARKUP.formatted(extImpYieldlab.getAdslotId(), this.makeNurl(bidRequest, extImpYieldlab, yieldlabResponse));
    }

    private String makeNurl(BidRequest bidRequest, ExtImpYieldlab extImpYieldlab, YieldlabResponse yieldlabResponse) {
        String timestamp = YieldlabBidder.isDebugEnabled(bidRequest) ? "200000" : String.valueOf(this.clock.instant().getEpochSecond());
        URIBuilder uriBuilder = new URIBuilder().addParameter("ts", timestamp).addParameter("id", extImpYieldlab.getExtId()).addParameter("pvid", yieldlabResponse.getPvid());
        User user = bidRequest.getUser();
        if (user != null && StringUtils.isNotBlank((CharSequence)user.getBuyeruid())) {
            uriBuilder.addParameter("ids", String.join((CharSequence)"ylid:", user.getBuyeruid()));
        }
        String gdpr = YieldlabBidder.getGdprParameter(bidRequest.getRegs());
        String consent = YieldlabBidder.getConsentParameter(bidRequest.getUser());
        if (StringUtils.isNotBlank((CharSequence)gdpr) && StringUtils.isNotBlank((CharSequence)consent)) {
            uriBuilder.addParameter("gdpr", gdpr).addParameter("consent", consent);
        }
        return AD_SOURCE_URL.formatted(extImpYieldlab.getAdslotId(), extImpYieldlab.getSupplyId(), yieldlabResponse.getAdSize(), uriBuilder.toString().replace("?", ""));
    }
}

