/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.tripleliftnative;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Publisher;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtPublisher;
import org.prebid.server.proto.openrtb.ext.request.ExtPublisherPrebid;
import org.prebid.server.proto.openrtb.ext.request.triplelift.ExtImpTriplelift;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class TripleliftNativeBidder
implements Bidder<BidRequest> {
    private static final String UNKNOWN_PUBLISHER_ID = "unknown";
    private static final TypeReference<ExtPrebid<?, ExtImpTriplelift>> TRIPLELIFT_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpTriplelift>>(){};
    private final String endpointUrl;
    private final List<String> publisherWhiteList;
    private final JacksonMapper mapper;

    public TripleliftNativeBidder(String endpointUrl, List<String> publisherWhiteList, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.publisherWhiteList = Objects.requireNonNull(publisherWhiteList);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ArrayList<Imp> validImps = new ArrayList<Imp>();
        for (Imp imp : bidRequest.getImp()) {
            try {
                validImps.add(this.modifyImp(imp));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        String publisherId = this.effectivePublisherId(bidRequest);
        if (!this.publisherWhiteList.contains(publisherId)) {
            errors.add(BidderError.badInput("Unsupported publisher for triplelift_native"));
            return Result.of(Collections.emptyList(), errors);
        }
        if (validImps.isEmpty()) {
            errors.add(BidderError.badInput("No valid impressions for triplelift"));
            return Result.of(Collections.emptyList(), errors);
        }
        BidRequest updatedRequest = bidRequest.toBuilder().imp(validImps).build();
        return Result.of(Collections.singletonList(BidderUtil.defaultRequest(updatedRequest, this.endpointUrl, this.mapper)), errors);
    }

    private Imp modifyImp(Imp imp) throws PreBidException {
        if (imp.getXNative() == null) {
            throw new PreBidException("no native object specified");
        }
        ExtImpTriplelift impExt = this.parseExtImpTriplelift(imp);
        String inventoryCode = impExt.getInventoryCode();
        if (StringUtils.isBlank((CharSequence)inventoryCode)) {
            throw new PreBidException("no inv_code specified");
        }
        return imp.toBuilder().tagid(inventoryCode).bidfloor(impExt.getFloor()).build();
    }

    private ExtImpTriplelift parseExtImpTriplelift(Imp imp) {
        try {
            return (ExtImpTriplelift)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), TRIPLELIFT_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage(), e);
        }
    }

    private String effectivePublisherId(BidRequest bidRequest) {
        ExtPublisherPrebid extPublisherPrebid;
        Publisher publisher = TripleliftNativeBidder.findPublisher(bidRequest);
        if (publisher == null) {
            return UNKNOWN_PUBLISHER_ID;
        }
        String id = publisher.getId();
        ExtPublisher publisherExt = publisher.getExt();
        ExtPublisherPrebid extPublisherPrebid2 = extPublisherPrebid = publisherExt != null ? publisherExt.getPrebid() : null;
        if (extPublisherPrebid != null && StringUtils.isNotBlank((CharSequence)extPublisherPrebid.getParentAccount())) {
            return extPublisherPrebid.getParentAccount();
        }
        return StringUtils.isBlank((CharSequence)id) ? UNKNOWN_PUBLISHER_ID : id;
    }

    private static Publisher findPublisher(BidRequest bidRequest) {
        App app = bidRequest.getApp();
        if (app != null) {
            return app.getPublisher();
        }
        Site site = bidRequest.getSite();
        if (site != null) {
            return site.getPublisher();
        }
        return null;
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues(TripleliftNativeBidder.extractBids(bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse) {
        return bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid()) ? Collections.emptyList() : TripleliftNativeBidder.bidsFromResponse(bidResponse);
    }

    private static List<BidderBid> bidsFromResponse(BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of(bid, BidType.xNative, bidResponse.getCur())).toList();
    }
}

