/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.triplelift;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.bidder.triplelift.model.TripleliftInnerExt;
import org.prebid.server.bidder.triplelift.model.TripleliftResponseExt;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.triplelift.ExtImpTriplelift;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class TripleliftBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpTriplelift>> TRIPLELIFT_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpTriplelift>>(){};
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public TripleliftBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public final Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ArrayList<Imp> validImps = new ArrayList<Imp>();
        for (Imp imp : bidRequest.getImp()) {
            try {
                validImps.add(this.modifyImp(imp));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        if (validImps.isEmpty()) {
            errors.add(BidderError.badInput("No valid impressions for triplelift"));
            return Result.withErrors(errors);
        }
        BidRequest updatedRequest = bidRequest.toBuilder().imp(validImps).build();
        return Result.of(Collections.singletonList(BidderUtil.defaultRequest(updatedRequest, this.endpointUrl, this.mapper)), errors);
    }

    private Imp modifyImp(Imp imp) throws PreBidException {
        if (imp.getBanner() == null && imp.getVideo() == null) {
            throw new PreBidException("neither Banner nor Video object specified");
        }
        ExtImpTriplelift impExt = this.parseImpExt(imp);
        return imp.toBuilder().tagid(impExt.getInventoryCode()).bidfloor((BigDecimal)ObjectUtils.defaultIfNull((Object)impExt.getFloor(), (Object)imp.getBidfloor())).build();
    }

    private ExtImpTriplelift parseImpExt(Imp imp) {
        try {
            return (ExtImpTriplelift)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), TRIPLELIFT_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        BidResponse bidResponse;
        try {
            bidResponse = this.decodeBody(httpCall);
        }
        catch (PreBidException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Result.empty();
        }
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ArrayList<BidderBid> bidderBids = new ArrayList<BidderBid>();
        block4: for (SeatBid seatBid : bidResponse.getSeatbid()) {
            for (Bid bid : seatBid.getBid()) {
                ObjectNode bidExt = bid.getExt();
                if (bidExt == null) {
                    errors.add(BidderError.badServerResponse("Empty ext in bid " + bid.getId()));
                    continue block4;
                }
                try {
                    TripleliftResponseExt tripleliftResponseExt = (TripleliftResponseExt)this.mapper.mapper().treeToValue((TreeNode)bidExt, TripleliftResponseExt.class);
                    BidType bidType = TripleliftBidder.getBidType(tripleliftResponseExt);
                    bidderBids.add(BidderBid.of(bid, bidType, bidResponse.getCur()));
                }
                catch (JsonProcessingException e) {
                    errors.add(BidderError.badServerResponse(e.getMessage()));
                }
            }
        }
        return Result.of(bidderBids, errors);
    }

    private BidResponse decodeBody(BidderCall<BidRequest> httpCall) {
        try {
            return this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
        }
        catch (DecodeException e) {
            throw new PreBidException(e.getMessage(), e);
        }
    }

    private static BidType getBidType(TripleliftResponseExt tripleliftResponseExt) {
        return Optional.ofNullable(tripleliftResponseExt).map(TripleliftResponseExt::getTripleliftPb).map(TripleliftInnerExt::getFormat).filter(format -> format.equals(11) || format.equals(12) || format.equals(17)).map(format -> BidType.video).orElse(BidType.banner);
    }
}

