/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.smaato;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Native;
import com.iab.openrtb.request.Publisher;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.User;
import com.iab.openrtb.request.Video;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.model.Endpoint;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.bidder.smaato.proto.SmaatoBidExt;
import org.prebid.server.bidder.smaato.proto.SmaatoBidRequestExt;
import org.prebid.server.bidder.smaato.proto.SmaatoImage;
import org.prebid.server.bidder.smaato.proto.SmaatoImageAd;
import org.prebid.server.bidder.smaato.proto.SmaatoImg;
import org.prebid.server.bidder.smaato.proto.SmaatoMediaData;
import org.prebid.server.bidder.smaato.proto.SmaatoRichMediaAd;
import org.prebid.server.bidder.smaato.proto.SmaatoRichmedia;
import org.prebid.server.bidder.smaato.proto.SmaatoSiteExtData;
import org.prebid.server.bidder.smaato.proto.SmaatoUserExtData;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidServer;
import org.prebid.server.proto.openrtb.ext.request.ExtSite;
import org.prebid.server.proto.openrtb.ext.request.ExtUser;
import org.prebid.server.proto.openrtb.ext.request.smaato.ExtImpSmaato;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebid;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebidVideo;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class SmaatoBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpSmaato>> SMAATO_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpSmaato>>(){};
    private static final String CLIENT_VERSION = "prebid_server_0.4";
    private static final String SMT_ADTYPE_HEADER = "X-Smt-Adtype";
    private static final String SMT_EXPIRES_HEADER = "X-Smt-Expires";
    private static final String SMT_AD_TYPE_IMG = "Img";
    private static final String SMT_ADTYPE_RICHMEDIA = "Richmedia";
    private static final String SMT_ADTYPE_VIDEO = "Video";
    private static final String IMP_EXT_SKADN_FIELD = "skadn";
    private static final int DEFAULT_TTL = 300;
    private final String endpointUrl;
    private final JacksonMapper mapper;
    private final Clock clock;

    public SmaatoBidder(String endpointUrl, JacksonMapper mapper, Clock clock) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
        this.clock = Objects.requireNonNull(clock);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        BidRequest enrichedRequest;
        try {
            enrichedRequest = this.enrichRequestWithCommonProperties(request);
        }
        catch (PreBidException e) {
            return Result.withError(BidderError.badInput(e.getMessage()));
        }
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        if (SmaatoBidder.isVideoRequest(request)) {
            return Result.of(this.constructPodRequests(enrichedRequest, errors), errors);
        }
        return Result.of(this.constructIndividualRequests(enrichedRequest, errors), errors);
    }

    private BidRequest enrichRequestWithCommonProperties(BidRequest bidRequest) {
        return bidRequest.toBuilder().user(this.modifyUser(bidRequest.getUser())).site(this.modifySite(bidRequest.getSite())).ext(this.mapper.fillExtension(ExtRequest.empty(), SmaatoBidRequestExt.of(CLIENT_VERSION))).build();
    }

    private User modifyUser(User user) {
        String keywords;
        Integer yob;
        ExtUser userExt = SmaatoBidder.getIfNotNull(user, User::getExt);
        if (userExt == null) {
            return user;
        }
        ObjectNode extDataNode = userExt.getData();
        if (extDataNode == null || extDataNode.isEmpty()) {
            return user;
        }
        SmaatoUserExtData smaatoUserExtData = this.convertExt(extDataNode, SmaatoUserExtData.class);
        User.UserBuilder userBuilder = user.toBuilder();
        String gender = smaatoUserExtData.getGender();
        if (StringUtils.isNotBlank((CharSequence)gender)) {
            userBuilder.gender(gender);
        }
        if (!BidderUtil.isNullOrZero(yob = smaatoUserExtData.getYob())) {
            userBuilder.yob(yob);
        }
        if (StringUtils.isNotBlank((CharSequence)(keywords = smaatoUserExtData.getKeywords()))) {
            userBuilder.keywords(keywords);
        }
        return userBuilder.ext(userExt.toBuilder().data(null).build()).build();
    }

    private Site modifySite(Site site) {
        ExtSite siteExt = SmaatoBidder.getIfNotNull(site, Site::getExt);
        if (siteExt != null) {
            SmaatoSiteExtData data = this.convertExt(siteExt.getData(), SmaatoSiteExtData.class);
            String keywords = SmaatoBidder.getIfNotNull(data, SmaatoSiteExtData::getKeywords);
            return Site.builder().keywords(keywords).ext(null).build();
        }
        return site;
    }

    private <T> T convertExt(ObjectNode ext, Class<T> className) {
        try {
            return (T)this.mapper.mapper().convertValue((Object)ext, className);
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Cannot decode extension: " + e.getMessage(), e);
        }
    }

    private static boolean isVideoRequest(BidRequest bidRequest) {
        ExtRequestPrebid prebid = SmaatoBidder.getIfNotNull(bidRequest.getExt(), ExtRequest::getPrebid);
        ExtRequestPrebidServer server = SmaatoBidder.getIfNotNull(prebid, ExtRequestPrebid::getServer);
        String endpointName = SmaatoBidder.getIfNotNull(server, ExtRequestPrebidServer::getEndpoint);
        return StringUtils.equals((CharSequence)endpointName, (CharSequence)Endpoint.openrtb2_video.value());
    }

    private List<HttpRequest<BidRequest>> constructPodRequests(BidRequest bidRequest, List<BidderError> errors) {
        ArrayList<Imp> validImps = new ArrayList<Imp>();
        for (Imp imp : bidRequest.getImp()) {
            if (imp.getVideo() == null) {
                errors.add(BidderError.badInput("Invalid MediaType. Smaato only supports Video for AdPod."));
                continue;
            }
            validImps.add(imp);
        }
        return validImps.stream().collect(Collectors.groupingBy(SmaatoBidder::extractPod, Collectors.toList())).values().stream().map(impsPod -> this.preparePodRequest(bidRequest, (List<Imp>)impsPod, errors)).filter(Objects::nonNull).map(this::constructHttpRequest).toList();
    }

    private static String extractPod(Imp imp) {
        return imp.getId().split("_")[0];
    }

    private BidRequest preparePodRequest(BidRequest bidRequest, List<Imp> imps, List<BidderError> errors) {
        try {
            ObjectNode impExt = imps.get(0).getExt();
            ExtImpSmaato extImpSmaato = (ExtImpSmaato)((ExtPrebid)this.mapper.mapper().convertValue((Object)impExt, SMAATO_EXT_TYPE_REFERENCE)).getBidder();
            String publisherId = SmaatoBidder.getIfNotNullOrThrow(extImpSmaato, ExtImpSmaato::getPublisherId, "publisherId");
            String adBreakId = SmaatoBidder.getIfNotNullOrThrow(extImpSmaato, ExtImpSmaato::getAdbreakId, "adbreakId");
            return this.modifyBidRequest(bidRequest, publisherId, () -> this.modifyImpsForAdBreak(imps, adBreakId, this.resolveImpExtSkadn(impExt)));
        }
        catch (IllegalArgumentException | PreBidException e) {
            errors.add(BidderError.badInput(e.getMessage()));
            return null;
        }
    }

    private BidRequest modifyBidRequest(BidRequest bidRequest, String publisherId, Supplier<List<Imp>> impSupplier) {
        Publisher publisher = Publisher.builder().id(publisherId).build();
        Site site = bidRequest.getSite();
        App app = bidRequest.getApp();
        BidRequest.BidRequestBuilder bidRequestBuilder = bidRequest.toBuilder();
        if (site != null) {
            bidRequestBuilder.site(site.toBuilder().publisher(publisher).build());
        } else if (app != null) {
            bidRequestBuilder.app(app.toBuilder().publisher(publisher).build());
        } else {
            throw new PreBidException("Missing Site/App.");
        }
        return bidRequestBuilder.imp(impSupplier.get()).build();
    }

    private List<Imp> modifyImpsForAdBreak(List<Imp> imps, String adBreakId, ObjectNode impExtSkadn) {
        return IntStream.range(0, imps.size()).mapToObj(idx -> this.modifyImpForAdBreak((Imp)imps.get(idx), idx + 1, adBreakId, (ObjectNode)(idx == 0 ? impExtSkadn : null))).toList();
    }

    private Imp modifyImpForAdBreak(Imp imp, Integer sequence, String adBreakId, ObjectNode impExtSkadn) {
        Video modifiedVideo = imp.getVideo().toBuilder().sequence(sequence).ext((ObjectNode)this.mapper.mapper().createObjectNode().set("context", (JsonNode)TextNode.valueOf((String)"adpod"))).build();
        return imp.toBuilder().tagid(adBreakId).video(modifiedVideo).ext(impExtSkadn).build();
    }

    private List<HttpRequest<BidRequest>> constructIndividualRequests(BidRequest bidRequest, List<BidderError> errors) {
        return this.splitImps(bidRequest.getImp(), errors).stream().map(imp -> this.prepareIndividualRequest(bidRequest, (Imp)imp, errors)).filter(Objects::nonNull).map(this::constructHttpRequest).toList();
    }

    private List<Imp> splitImps(List<Imp> imps, List<BidderError> errors) {
        ArrayList<Imp> splitImps = new ArrayList<Imp>();
        for (Imp imp : imps) {
            Banner banner = imp.getBanner();
            Video video = imp.getVideo();
            Native xNative = imp.getXNative();
            if (ObjectUtils.allNull((Object[])new Object[]{video, banner, xNative})) {
                errors.add(BidderError.badInput("Invalid MediaType. Smaato only supports Banner, Video and Native."));
                continue;
            }
            if (video != null) {
                splitImps.add(imp.toBuilder().banner(null).xNative(null).build());
            }
            if (banner != null) {
                splitImps.add(imp.toBuilder().video(null).xNative(null).build());
            }
            if (xNative == null) continue;
            splitImps.add(imp.toBuilder().banner(null).video(null).build());
        }
        return splitImps;
    }

    private BidRequest prepareIndividualRequest(BidRequest bidRequest, Imp imp, List<BidderError> errors) {
        try {
            ObjectNode impExt = imp.getExt();
            ExtImpSmaato extImpSmaato = (ExtImpSmaato)((ExtPrebid)this.mapper.mapper().convertValue((Object)impExt, SMAATO_EXT_TYPE_REFERENCE)).getBidder();
            String publisherId = SmaatoBidder.getIfNotNullOrThrow(extImpSmaato, ExtImpSmaato::getPublisherId, "publisherId");
            String adSpaceId = SmaatoBidder.getIfNotNullOrThrow(extImpSmaato, ExtImpSmaato::getAdspaceId, "adspaceId");
            return this.modifyBidRequest(bidRequest, publisherId, () -> this.modifyImpForAdSpace(imp, adSpaceId, this.resolveImpExtSkadn(impExt)));
        }
        catch (IllegalArgumentException | PreBidException e) {
            errors.add(BidderError.badInput(e.getMessage()));
            return null;
        }
    }

    private ObjectNode resolveImpExtSkadn(ObjectNode impExt) {
        if (!impExt.has(IMP_EXT_SKADN_FIELD)) {
            return null;
        }
        if (impExt.get(IMP_EXT_SKADN_FIELD).isEmpty() || !impExt.get(IMP_EXT_SKADN_FIELD).isObject()) {
            throw new PreBidException("Invalid imp.ext.skadn");
        }
        return (ObjectNode)this.mapper.mapper().createObjectNode().set(IMP_EXT_SKADN_FIELD, impExt.get(IMP_EXT_SKADN_FIELD));
    }

    private List<Imp> modifyImpForAdSpace(Imp imp, String adSpaceId, ObjectNode impExtSkadn) {
        Imp modifiedImp = imp.toBuilder().tagid(adSpaceId).banner(SmaatoBidder.getIfNotNull(imp.getBanner(), SmaatoBidder::modifyBanner)).ext(impExtSkadn).build();
        return Collections.singletonList(modifiedImp);
    }

    private static Banner modifyBanner(Banner banner) {
        if (banner.getW() != null && banner.getH() != null) {
            return banner;
        }
        List<Format> format = banner.getFormat();
        if (CollectionUtils.isEmpty(format)) {
            throw new PreBidException("No sizes provided for Banner.");
        }
        Format firstFormat = format.get(0);
        return banner.toBuilder().w(firstFormat.getW()).h(firstFormat.getH()).build();
    }

    private HttpRequest<BidRequest> constructHttpRequest(BidRequest bidRequest) {
        return BidderUtil.defaultRequest(bidRequest, this.endpointUrl, this.mapper);
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return this.extractBids(bidResponse, httpCall.getResponse().getHeaders());
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badInput(e.getMessage()));
        }
    }

    private Result<List<BidderBid>> extractBids(BidResponse bidResponse, MultiMap headers) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Result.empty();
        }
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        List<BidderBid> bidderBids = bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> this.bidderBid((Bid)bid, bidResponse.getCur(), headers, (List<BidderError>)errors)).filter(Objects::nonNull).toList();
        return Result.of(bidderBids, errors);
    }

    private BidderBid bidderBid(Bid bid, String currency, MultiMap headers, List<BidderError> errors) {
        try {
            String bidAdm = bid.getAdm();
            if (StringUtils.isBlank((CharSequence)bidAdm)) {
                throw new PreBidException("Empty ad markup in bid with id: " + bid.getId());
            }
            String markupType = SmaatoBidder.getAdMarkupType(headers, bidAdm);
            BidType bidType = SmaatoBidder.getBidType(markupType);
            Bid updatedBid = bid.toBuilder().adm(this.renderAdMarkup(markupType, bidAdm)).exp(this.getTtl(headers)).ext(this.buildExtPrebid(bid, bidType)).build();
            return BidderBid.of(updatedBid, bidType, currency);
        }
        catch (PreBidException e) {
            errors.add(BidderError.badInput(e.getMessage()));
            return null;
        }
    }

    private ObjectNode buildExtPrebid(Bid bid, BidType bidType) {
        ExtBidPrebidVideo extBidPrebidVideo = this.getExtBidPrebidVideo(bid, bidType);
        ExtBidPrebid extBidPrebid = ExtBidPrebid.builder().video(extBidPrebidVideo).build();
        return (ObjectNode)this.mapper.mapper().valueToTree(ExtPrebid.of(extBidPrebid, null));
    }

    private ExtBidPrebidVideo getExtBidPrebidVideo(Bid bid, BidType bidType) {
        ObjectNode bidExt = bid.getExt();
        if (bidType != BidType.video || bidExt == null) {
            return null;
        }
        List<String> categories = bid.getCat();
        String primaryCategory = CollectionUtils.isNotEmpty(categories) ? categories.get(0) : null;
        try {
            SmaatoBidExt smaatoBidExt = (SmaatoBidExt)this.mapper.mapper().convertValue((Object)bidExt, SmaatoBidExt.class);
            return ExtBidPrebidVideo.of(smaatoBidExt.getDuration(), primaryCategory);
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Invalid bid.ext.");
        }
    }

    private int getTtl(MultiMap headers) {
        try {
            long expiresAtMillis = Long.parseLong(headers.get(SMT_EXPIRES_HEADER));
            long currentTimeMillis = this.clock.millis();
            return (int)Math.max((expiresAtMillis - currentTimeMillis) / 1000L, 0L);
        }
        catch (NumberFormatException e) {
            return 300;
        }
    }

    private static String getAdMarkupType(MultiMap headers, String adm) {
        String adMarkupType = headers.get(SMT_ADTYPE_HEADER);
        if (StringUtils.isNotBlank((CharSequence)adMarkupType)) {
            return adMarkupType;
        }
        if (adm.startsWith("{\"image\":")) {
            return SMT_AD_TYPE_IMG;
        }
        if (adm.startsWith("{\"richmedia\":")) {
            return SMT_ADTYPE_RICHMEDIA;
        }
        if (adm.startsWith("<?xml")) {
            return SMT_ADTYPE_VIDEO;
        }
        throw new PreBidException("Invalid ad markup %s.".formatted(adm));
    }

    private String renderAdMarkup(String markupType, String adm) {
        return switch (markupType) {
            case SMT_AD_TYPE_IMG -> this.extractAdmImage(adm);
            case SMT_ADTYPE_RICHMEDIA -> this.extractAdmRichMedia(adm);
            case SMT_ADTYPE_VIDEO -> markupType;
            default -> throw new PreBidException("Unknown markup type " + markupType);
        };
    }

    private String extractAdmImage(String adm) {
        SmaatoImageAd imageAd = this.convertAdmToAd(adm, SmaatoImageAd.class);
        SmaatoImage image = imageAd.getImage();
        if (image == null) {
            throw new PreBidException("bid.adm.image is empty");
        }
        StringBuilder clickEvent = new StringBuilder();
        CollectionUtils.emptyIfNull(image.getClickTrackers()).forEach(tracker -> clickEvent.append("fetch(decodeURIComponent('%s'.replace(/\\+/g, ' ')), {cache: 'no-cache'});".formatted(HttpUtil.encodeUrl(StringUtils.stripToEmpty((String)tracker)))));
        StringBuilder impressionTracker = new StringBuilder();
        CollectionUtils.emptyIfNull(image.getImpressionTrackers()).forEach(tracker -> impressionTracker.append("<img src=\"%s\" alt=\"\" width=\"0\" height=\"0\"/>".formatted(tracker)));
        SmaatoImg img = image.getImg();
        return "<div style=\"cursor:pointer\" onclick=\"%s;window.open(decodeURIComponent('%s'.replace(/\\+/g, ' ')));\"><img src=\"%s\" width=\"%d\" height=\"%d\"/>%s</div>".formatted(clickEvent, HttpUtil.encodeUrl(StringUtils.stripToEmpty((String)SmaatoBidder.getIfNotNull(img, SmaatoImg::getCtaurl))), StringUtils.stripToEmpty((String)SmaatoBidder.getIfNotNull(img, SmaatoImg::getUrl)), SmaatoBidder.stripToZero(SmaatoBidder.getIfNotNull(img, SmaatoImg::getW)), SmaatoBidder.stripToZero(SmaatoBidder.getIfNotNull(img, SmaatoImg::getH)), impressionTracker);
    }

    private String extractAdmRichMedia(String adm) {
        SmaatoRichMediaAd richMediaAd = this.convertAdmToAd(adm, SmaatoRichMediaAd.class);
        SmaatoRichmedia richmedia = richMediaAd.getRichmedia();
        if (richmedia == null) {
            throw new PreBidException("bid.adm.richmedia is empty");
        }
        StringBuilder clickEvent = new StringBuilder();
        CollectionUtils.emptyIfNull(richmedia.getClickTrackers()).forEach(tracker -> clickEvent.append("fetch(decodeURIComponent('%s'), {cache: 'no-cache'});".formatted(HttpUtil.encodeUrl(StringUtils.stripToEmpty((String)tracker)))));
        StringBuilder impressionTracker = new StringBuilder();
        CollectionUtils.emptyIfNull(richmedia.getImpressionTrackers()).forEach(tracker -> impressionTracker.append("<img src=\"%s\" alt=\"\" width=\"0\" height=\"0\"/>".formatted(tracker)));
        return "<div onclick=\"%s\">%s%s</div>".formatted(clickEvent, StringUtils.stripToEmpty((String)SmaatoBidder.getIfNotNull(richmedia.getMediadata(), SmaatoMediaData::getContent)), impressionTracker);
    }

    private <T> T convertAdmToAd(String value, Class<T> className) {
        try {
            return this.mapper.decodeValue(value, className);
        }
        catch (DecodeException e) {
            throw new PreBidException("Cannot decode bid.adm: " + e.getMessage(), e);
        }
    }

    private static BidType getBidType(String markupType) {
        return switch (markupType) {
            case SMT_AD_TYPE_IMG, SMT_ADTYPE_RICHMEDIA -> BidType.banner;
            case SMT_ADTYPE_VIDEO -> BidType.video;
            default -> throw new PreBidException("Invalid markupType " + markupType);
        };
    }

    private static <T, R> R getIfNotNullOrThrow(T target, Function<T, R> getter, String propertyName) {
        R result = SmaatoBidder.getIfNotNull(target, getter);
        if (result == null) {
            throw new PreBidException("Missing %s property.".formatted(propertyName));
        }
        return result;
    }

    private static <T, R> R getIfNotNull(T target, Function<T, R> getter) {
        return target != null ? (R)getter.apply(target) : null;
    }

    private static int stripToZero(Integer target) {
        return (Integer)ObjectUtils.defaultIfNull((Object)target, (Object)0);
    }
}

