/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.orbidder;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.currency.CurrencyConversionService;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.orbidder.ExtImpOrbidder;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class OrbidderBidder
implements Bidder<BidRequest> {
    private static final String BIDDER_CURRENCY = "EUR";
    private static final TypeReference<ExtPrebid<?, ExtImpOrbidder>> ORBIDDER_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpOrbidder>>(){};
    private final String endpointUrl;
    private final CurrencyConversionService currencyConversionService;
    private final JacksonMapper mapper;

    public OrbidderBidder(String endpointUrl, CurrencyConversionService currencyConversionService, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.currencyConversionService = Objects.requireNonNull(currencyConversionService);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ArrayList<Imp> validImps = new ArrayList<Imp>();
        for (Imp imp : request.getImp()) {
            try {
                BigDecimal bidFloor = this.resolveBidFloor(request, imp.getBidfloorcur(), imp.getBidfloor());
                this.parseImpExt(imp);
                validImps.add(OrbidderBidder.modifyImp(imp, bidFloor));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        BidRequest outgoingRequest = request.toBuilder().imp(validImps).build();
        return Result.of(Collections.singletonList(BidderUtil.defaultRequest(outgoingRequest, this.endpointUrl, this.mapper)), errors);
    }

    private BigDecimal resolveBidFloor(BidRequest bidRequest, String bidfloorcur, BigDecimal bidfloor) {
        if (BidderUtil.isValidPrice(bidfloor) && !StringUtils.equalsIgnoreCase((CharSequence)bidfloorcur, (CharSequence)BIDDER_CURRENCY) && StringUtils.isNotBlank((CharSequence)bidfloorcur)) {
            return this.currencyConversionService.convertCurrency(bidfloor, bidRequest, bidfloorcur, BIDDER_CURRENCY);
        }
        return bidfloor;
    }

    private static Imp modifyImp(Imp imp, BigDecimal bidFloor) {
        return imp.toBuilder().bidfloorcur(BIDDER_CURRENCY).bidfloor(bidFloor).build();
    }

    private void parseImpExt(Imp imp) {
        try {
            this.mapper.mapper().convertValue((Object)imp.getExt(), ORBIDDER_EXT_TYPE_REFERENCE);
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage(), e);
        }
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        BidResponse bidResponse;
        try {
            bidResponse = this.decodeBodyToBidResponse(httpCall);
        }
        catch (PreBidException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        List<BidderBid> bidderBids = bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> this.toBidderBid((Bid)bid, bidResponse.getCur(), (List<BidderError>)errors)).filter(Objects::nonNull).toList();
        return Result.of(bidderBids, errors);
    }

    private BidResponse decodeBodyToBidResponse(BidderCall<BidRequest> httpCall) {
        try {
            return this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
        }
        catch (DecodeException e) {
            throw new PreBidException(e.getMessage(), e);
        }
    }

    private BidderBid toBidderBid(Bid bid, String cur, List<BidderError> errors) {
        BidType bidType;
        try {
            bidType = OrbidderBidder.getBidType(bid.getMtype());
        }
        catch (PreBidException e) {
            errors.add(BidderError.badServerResponse(e.getMessage()));
            return null;
        }
        return BidderBid.of(bid, bidType, cur);
    }

    private static BidType getBidType(Integer mType) {
        return switch (mType) {
            case 1 -> BidType.banner;
            case 2 -> BidType.video;
            case 3 -> BidType.audio;
            case 4 -> BidType.xNative;
            default -> throw new PreBidException("Unsupported mType " + mType);
        };
    }
}

