/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.openweb;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.openweb.ExtImpOpenweb;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class OpenWebBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpOpenweb>> OPENWEB_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpOpenweb>>(){};
    private final JacksonMapper mapper;
    private final String endpointUrl;

    public OpenWebBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = Objects.requireNonNull(HttpUtil.validateUrl(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        HashMap<Integer, List<Imp>> sourceIdToModifiedImp = new HashMap<Integer, List<Imp>>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        for (Imp imp : request.getImp()) {
            try {
                ExtImpOpenweb extImpOpenweb = this.parseImpExt(imp);
                Integer sourceId = extImpOpenweb.getSourceId();
                Imp modifiedImp = this.modifyImp(imp, extImpOpenweb);
                if (sourceIdToModifiedImp.containsKey(sourceId)) {
                    ((List)sourceIdToModifiedImp.get(sourceId)).add(modifiedImp);
                    continue;
                }
                sourceIdToModifiedImp.put(sourceId, new ArrayList<Imp>(Collections.singletonList(modifiedImp)));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        if (sourceIdToModifiedImp.isEmpty()) {
            return Result.withErrors(errors);
        }
        return Result.of(this.makeGroupRequests(request, sourceIdToModifiedImp), errors);
    }

    private ExtImpOpenweb parseImpExt(Imp imp) {
        try {
            return (ExtImpOpenweb)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), OPENWEB_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("ignoring imp id=%s, error while encoding impExt, err: %s".formatted(imp.getId(), e.getMessage()));
        }
    }

    private Imp modifyImp(Imp imp, ExtImpOpenweb impExt) {
        ObjectNode modifiedImpExt = (ObjectNode)this.mapper.mapper().createObjectNode().set("openweb", this.mapper.mapper().valueToTree((Object)impExt));
        BigDecimal bidFloor = impExt.getBidFloor();
        BigDecimal resolvedBidFloor = BidderUtil.isValidPrice(bidFloor) ? bidFloor : imp.getBidfloor();
        return imp.toBuilder().bidfloor(resolvedBidFloor).ext(modifiedImpExt).build();
    }

    private List<HttpRequest<BidRequest>> makeGroupRequests(BidRequest request, Map<Integer, List<Imp>> sourceIdToImps) {
        return sourceIdToImps.entrySet().stream().map(impGroupEntry -> this.makeGroupRequest(request, (List)impGroupEntry.getValue(), (Integer)impGroupEntry.getKey())).toList();
    }

    private HttpRequest<BidRequest> makeGroupRequest(BidRequest request, List<Imp> imps, Integer sourceId) {
        BidRequest modifiedRequest = request.toBuilder().imp(imps).build();
        return BidderUtil.defaultRequest(modifiedRequest, this.resolveEndpoint(sourceId), this.mapper);
    }

    private String resolveEndpoint(Integer sourceId) {
        return "%s?aid=%d".formatted(this.endpointUrl, sourceId);
    }

    @Override
    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of(this.extractBids(httpCall.getRequest().getPayload(), bidResponse, errors), errors);
        }
        catch (DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse, List<BidderError> errors) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return this.bidsFromResponse(bidRequest, bidResponse, errors);
    }

    private List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse, List<BidderError> errors) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> this.toBidderBid((Bid)bid, bidResponse, bidRequest.getImp(), errors)).filter(Objects::nonNull).toList();
    }

    private BidderBid toBidderBid(Bid bid, BidResponse bidResponse, List<Imp> imps, List<BidderError> errors) {
        try {
            return BidderBid.of(bid, OpenWebBidder.getBidType(bid.getId(), bid.getImpid(), imps), bidResponse.getCur());
        }
        catch (PreBidException e) {
            errors.add(BidderError.badServerResponse(e.getMessage()));
            return null;
        }
    }

    private static BidType getBidType(String bidId, String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!impId.equals(imp.getId())) continue;
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getBanner() == null) continue;
            return BidType.banner;
        }
        throw new PreBidException("ignoring bid id=%s, request doesn't contain any impression with id=%s".formatted(bidId, impId));
    }
}

