/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.model;

import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Set;

public final class HttpRequest<T> {
    private final HttpMethod method;
    private final String uri;
    private final MultiMap headers;
    private final Set<String> impIds;
    private final byte[] body;
    private final T payload;

    @ConstructorProperties(value={"method", "uri", "headers", "impIds", "body", "payload"})
    HttpRequest(HttpMethod method, String uri, MultiMap headers, Set<String> impIds, byte[] body, T payload) {
        this.method = method;
        this.uri = uri;
        this.headers = headers;
        this.impIds = impIds;
        this.body = body;
        this.payload = payload;
    }

    public static <T> HttpRequestBuilder<T> builder() {
        return new HttpRequestBuilder();
    }

    public HttpRequestBuilder<T> toBuilder() {
        return new HttpRequestBuilder().method(this.method).uri(this.uri).headers(this.headers).impIds(this.impIds).body(this.body).payload(this.payload);
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getUri() {
        return this.uri;
    }

    public MultiMap getHeaders() {
        return this.headers;
    }

    public Set<String> getImpIds() {
        return this.impIds;
    }

    public byte[] getBody() {
        return this.body;
    }

    public T getPayload() {
        return this.payload;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRequest)) {
            return false;
        }
        HttpRequest other = (HttpRequest)o;
        HttpMethod this$method = this.getMethod();
        HttpMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        MultiMap this$headers = this.getHeaders();
        MultiMap other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
            return false;
        }
        Set<String> this$impIds = this.getImpIds();
        Set<String> other$impIds = other.getImpIds();
        if (this$impIds == null ? other$impIds != null : !((Object)this$impIds).equals(other$impIds)) {
            return false;
        }
        if (!Arrays.equals(this.getBody(), other.getBody())) {
            return false;
        }
        T this$payload = this.getPayload();
        T other$payload = other.getPayload();
        return !(this$payload == null ? other$payload != null : !this$payload.equals(other$payload));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        MultiMap $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        Set<String> $impIds = this.getImpIds();
        result = result * 59 + ($impIds == null ? 43 : ((Object)$impIds).hashCode());
        result = result * 59 + Arrays.hashCode(this.getBody());
        T $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        return result;
    }

    public String toString() {
        return "HttpRequest(method=" + this.getMethod() + ", uri=" + this.getUri() + ", headers=" + this.getHeaders() + ", impIds=" + this.getImpIds() + ", body=" + Arrays.toString(this.getBody()) + ", payload=" + this.getPayload() + ")";
    }

    public static class HttpRequestBuilder<T> {
        private HttpMethod method;
        private String uri;
        private MultiMap headers;
        private Set<String> impIds;
        private byte[] body;
        private T payload;

        HttpRequestBuilder() {
        }

        public HttpRequestBuilder<T> method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public HttpRequestBuilder<T> uri(String uri) {
            this.uri = uri;
            return this;
        }

        public HttpRequestBuilder<T> headers(MultiMap headers) {
            this.headers = headers;
            return this;
        }

        public HttpRequestBuilder<T> impIds(Set<String> impIds) {
            this.impIds = impIds;
            return this;
        }

        public HttpRequestBuilder<T> body(byte[] body) {
            this.body = body;
            return this;
        }

        public HttpRequestBuilder<T> payload(T payload) {
            this.payload = payload;
            return this;
        }

        public HttpRequest<T> build() {
            return new HttpRequest<T>(this.method, this.uri, this.headers, this.impIds, this.body, this.payload);
        }

        public String toString() {
            return "HttpRequest.HttpRequestBuilder(method=" + this.method + ", uri=" + this.uri + ", headers=" + this.headers + ", impIds=" + this.impIds + ", body=" + Arrays.toString(this.body) + ", payload=" + this.payload + ")";
        }
    }
}

