/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.marsmedia;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.marsmedia.ExtImpMarsmedia;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

public class MarsmediaBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpMarsmedia>> MARSMEDIA_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpMarsmedia>>(){};
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public MarsmediaBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        BidRequest outgoingRequest;
        String firstImpZone;
        try {
            firstImpZone = this.resolveExtZone(bidRequest.getImp().get(0));
            outgoingRequest = MarsmediaBidder.createRequest(bidRequest);
        }
        catch (PreBidException e) {
            return Result.withError(BidderError.badInput(e.getMessage()));
        }
        String uri = "%s&zone=%s".formatted(this.endpointUrl, firstImpZone);
        MultiMap headers = MarsmediaBidder.resolveHeaders(bidRequest.getDevice());
        return Result.withValue(HttpRequest.builder().method(HttpMethod.POST).uri(uri).headers(headers).body(this.mapper.encodeToBytes(outgoingRequest)).payload(outgoingRequest).build());
    }

    private String resolveExtZone(Imp imp) {
        ExtImpMarsmedia extImpMarsmedia;
        try {
            extImpMarsmedia = (ExtImpMarsmedia)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), MARSMEDIA_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("ext.bidder not provided");
        }
        String zoneId = extImpMarsmedia.getZoneId();
        if (StringUtils.isBlank((CharSequence)zoneId)) {
            throw new PreBidException("ZoneId is empty");
        }
        return zoneId;
    }

    private static BidRequest createRequest(BidRequest request) {
        ArrayList<Imp> validImps = new ArrayList<Imp>();
        for (Imp imp : request.getImp()) {
            Banner banner = imp.getBanner();
            if (banner != null) {
                if (CollectionUtils.isNotEmpty(banner.getFormat())) {
                    validImps.add(imp.toBuilder().banner(MarsmediaBidder.updateBanner(banner)).build());
                    continue;
                }
                if (banner.getW() != null && banner.getH() != null) {
                    validImps.add(imp);
                    continue;
                }
                throw new PreBidException("No valid banner format in the bid request");
            }
            if (imp.getVideo() == null) continue;
            validImps.add(imp);
        }
        if (validImps.isEmpty()) {
            throw new PreBidException("No valid impression in the bid request");
        }
        return request.toBuilder().at(1).imp(validImps).build();
    }

    private static Banner updateBanner(Banner banner) {
        Format firstFormat = banner.getFormat().get(0);
        return banner.toBuilder().w((Integer)ObjectUtils.defaultIfNull((Object)firstFormat.getW(), (Object)0)).h((Integer)ObjectUtils.defaultIfNull((Object)firstFormat.getH(), (Object)0)).build();
    }

    private static MultiMap resolveHeaders(Device device) {
        MultiMap headers = HttpUtil.headers().add(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
        if (device != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.USER_AGENT_HEADER, device.getUa());
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.ACCEPT_LANGUAGE_HEADER, device.getLanguage());
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.X_FORWARDED_FOR_HEADER, device.getIp());
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.DNT_HEADER, Objects.toString(device.getDnt(), null));
        }
        return headers;
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of(MarsmediaBidder.extractBids(bidResponse, httpCall.getRequest().getPayload()), Collections.emptyList());
        }
        catch (DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse, BidRequest bidRequest) {
        return bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid()) ? Collections.emptyList() : MarsmediaBidder.bidsFromResponse(bidResponse.getSeatbid(), bidRequest.getImp(), bidResponse.getCur());
    }

    private static List<BidderBid> bidsFromResponse(List<SeatBid> seatbid, List<Imp> imps, String currency) {
        SeatBid firstSeatBid = seatbid.get(0);
        return firstSeatBid != null ? firstSeatBid.getBid().stream().filter(Objects::nonNull).map(bid -> BidderBid.of(bid, MarsmediaBidder.getBidType(bid.getImpid(), imps), currency)).toList() : Collections.emptyList();
    }

    private static BidType getBidType(String impid, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impid)) continue;
            return imp.getVideo() != null ? BidType.video : BidType.banner;
        }
        return BidType.banner;
    }
}

