/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.logan;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.logan.request.LoganRequestImpExt;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.logan.ExtImpLogan;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class LoganBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpLogan>> LOGAN_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpLogan>>(){};
    private static final String LOGAN_IMP_EXT_TYPE = "publisher";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public LoganBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        List<HttpRequest> httpRequests = request.getImp().stream().map(this::modifyImp).map(imp -> this.createSingleRequest((Imp)imp, request)).toList();
        return Result.withValues(httpRequests);
    }

    private Imp modifyImp(Imp imp) {
        return imp.toBuilder().ext((ObjectNode)this.mapper.mapper().valueToTree(ExtPrebid.of(null, LoganBidder.prepareImpExt(this.parseImpExt(imp))))).build();
    }

    private static LoganRequestImpExt prepareImpExt(ExtImpLogan impExt) {
        return LoganRequestImpExt.of(impExt.getPlacementId(), LOGAN_IMP_EXT_TYPE);
    }

    private ExtImpLogan parseImpExt(Imp imp) {
        try {
            return (ExtImpLogan)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), LOGAN_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private HttpRequest<BidRequest> createSingleRequest(Imp imp, BidRequest request) {
        BidRequest outgoingRequest = request.toBuilder().imp(Collections.singletonList(imp)).build();
        return BidderUtil.defaultRequest(outgoingRequest, this.endpointUrl, this.mapper);
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues(LoganBidder.extractBids(httpCall.getRequest().getPayload(), bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> BidderBid.of(bid, LoganBidder.getBidType(bid.getImpid(), bidRequest.getImp()), bidResponse.getCur())).toList();
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getXNative() == null) break;
            return BidType.xNative;
        }
        throw new PreBidException("Failed to find impression '%s'".formatted(impId));
    }
}

