/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.iqx;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.iqx.ExtImpIqx;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class IqxBidder
implements Bidder<BidRequest> {
    private static final String SOURCE_ID_MACRO = "{{SourceId}}";
    private static final String HOST_MACRO = "{{Host}}";
    private static final TypeReference<ExtPrebid<?, ExtImpIqx>> IQX_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpIqx>>(){};
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public IqxBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public final Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        ArrayList<HttpRequest<BidRequest>> httpRequests = new ArrayList<HttpRequest<BidRequest>>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        for (Imp imp : bidRequest.getImp()) {
            ExtImpIqx extImpIqx;
            try {
                extImpIqx = this.parseImpExt(imp);
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
                continue;
            }
            httpRequests.add(BidderUtil.defaultRequest(IqxBidder.updateBidRequest(bidRequest, imp), this.resolveEndpoint(extImpIqx), this.mapper));
        }
        return Result.of(httpRequests, errors);
    }

    private ExtImpIqx parseImpExt(Imp imp) {
        try {
            return (ExtImpIqx)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), IQX_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Failed to deserialize IQZonex extension: " + e.getMessage());
        }
    }

    private static BidRequest updateBidRequest(BidRequest bidRequest, Imp imp) {
        return bidRequest.toBuilder().imp(Collections.singletonList(imp)).build();
    }

    private String resolveEndpoint(ExtImpIqx extImpIqx) {
        return this.endpointUrl.replace(SOURCE_ID_MACRO, StringUtils.defaultString((String)extImpIqx.getPid())).replace(HOST_MACRO, StringUtils.defaultString((String)extImpIqx.getEnv()));
    }

    @Override
    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            ArrayList<BidderError> errors = new ArrayList<BidderError>();
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of(IqxBidder.extractBids(bidResponse, errors), errors);
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse, List<BidderError> errors) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            throw new PreBidException("Array SeatBid cannot be empty");
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> IqxBidder.makeBid(bid, bidResponse.getCur(), errors)).filter(Objects::nonNull).toList();
    }

    private static BidderBid makeBid(Bid bid, String currency, List<BidderError> errors) {
        try {
            return BidderBid.of(bid, IqxBidder.getBidType(bid), currency);
        }
        catch (PreBidException e) {
            errors.add(BidderError.badServerResponse(e.getMessage()));
            return null;
        }
    }

    private static BidType getBidType(Bid bid) {
        return switch ((Integer)ObjectUtils.defaultIfNull((Object)bid.getMtype(), (Object)0)) {
            case 1 -> BidType.banner;
            case 2 -> BidType.video;
            case 4 -> BidType.xNative;
            default -> throw new PreBidException("failed to parse bid mtype for impression id \"%s\"".formatted(bid.getImpid()));
        };
    }
}

