/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.inmobi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.inmobi.ExtImpInmobi;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class InmobiBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpInmobi>> INMOBI_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpInmobi>>(){};
    private static final int FIRST_IMP_INDEX = 0;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public InmobiBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ExtImpInmobi extImpInmobi;
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        Imp imp = request.getImp().get(0);
        try {
            extImpInmobi = this.parseImpExt(imp);
        }
        catch (PreBidException e) {
            return Result.withError(BidderError.badInput("bad InMobi bidder ext"));
        }
        if (StringUtils.isBlank((CharSequence)extImpInmobi.getPlc())) {
            return Result.withError(BidderError.badInput("'plc' is a required attribute for InMobi's bidder ext"));
        }
        ArrayList<Imp> updatedImps = new ArrayList<Imp>(request.getImp());
        updatedImps.set(0, this.updateImp(imp));
        BidRequest outgoingRequest = request.toBuilder().imp(updatedImps).build();
        return Result.of(Collections.singletonList(BidderUtil.defaultRequest(outgoingRequest, this.endpointUrl, this.mapper)), errors);
    }

    private ExtImpInmobi parseImpExt(Imp imp) {
        try {
            return (ExtImpInmobi)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), INMOBI_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage(), e);
        }
    }

    private Imp updateImp(Imp imp) {
        Banner banner = imp.getBanner();
        if (banner != null && (banner.getW() == null || banner.getH() == null || banner.getW() == 0 || banner.getH() == 0) && CollectionUtils.isNotEmpty(banner.getFormat())) {
            Format format = banner.getFormat().get(0);
            return imp.toBuilder().banner(banner.toBuilder().w(format.getW()).h(format.getH()).build()).build();
        }
        return imp;
    }

    @Override
    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of(this.extractBids(httpCall.getRequest().getPayload(), bidResponse), Collections.emptyList());
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return this.bidsFromResponse(bidRequest, bidResponse);
    }

    private List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of(bid, InmobiBidder.getBidType(bid.getImpid(), bidRequest.getImp()), bidResponse.getCur())).toList();
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getXNative() == null) continue;
            return BidType.xNative;
        }
        return BidType.banner;
    }
}

