/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.huaweiads.model;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum AdsType {
    BANNER(8),
    NATIVE(3),
    ROLL(60),
    REWARDED(7),
    SPLASH(1),
    MAGAZINELOCK(2),
    AUDIO(17),
    INTERSTITIAL(12),
    UNKNOWN(Integer.MIN_VALUE);

    private final int type;

    public static AdsType ofTypeName(String typeName) {
        return Arrays.stream(AdsType.values()).filter(value -> value.name().equals(StringUtils.upperCase((String)typeName))).findFirst().orElse(BANNER);
    }

    public static AdsType ofTypeNumber(Integer typeNumber) {
        return Arrays.stream(AdsType.values()).filter(value -> Objects.equals(value.type, typeNumber)).findFirst().orElse(UNKNOWN);
    }

    public int getType() {
        return this.type;
    }

    @ConstructorProperties(value={"type"})
    private AdsType(int type) {
        this.type = type;
    }
}

