/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.emxdigital;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.Video;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.emxdigital.ExtImpEmxDigital;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

public class EmxDigitalBidder
implements Bidder<BidRequest> {
    private static final String USD_CURRENCY = "USD";
    private static final Integer PROTOCOL_VAST_40 = 7;
    private static final TypeReference<ExtPrebid<?, ExtImpEmxDigital>> EMXDIGITAL_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpEmxDigital>>(){};
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public EmxDigitalBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        BidRequest bidRequest;
        try {
            bidRequest = this.makeBidRequest(request);
        }
        catch (PreBidException e) {
            return Result.withError(BidderError.badInput(e.getMessage()));
        }
        return Result.withValue(HttpRequest.builder().method(HttpMethod.POST).uri(this.makeUrl(request)).body(this.mapper.encodeToBytes(bidRequest)).headers(EmxDigitalBidder.makeHeaders(request)).payload(request).build());
    }

    private BidRequest makeBidRequest(BidRequest request) {
        boolean isSecure = EmxDigitalBidder.resolveUrl(request).startsWith("https");
        List<Imp> modifiedImps = request.getImp().stream().map(imp -> EmxDigitalBidder.modifyImp(imp, isSecure, this.unpackImpExt((Imp)imp))).toList();
        return request.toBuilder().imp(modifiedImps).build();
    }

    private static String resolveUrl(BidRequest request) {
        String page;
        Site site = request.getSite();
        String string = page = site != null ? site.getPage() : null;
        if (StringUtils.isNotBlank((CharSequence)page)) {
            return page;
        }
        App app = request.getApp();
        if (app != null) {
            if (StringUtils.isNotBlank((CharSequence)app.getDomain())) {
                return app.getDomain();
            }
            if (StringUtils.isNotBlank((CharSequence)app.getStoreurl())) {
                return app.getStoreurl();
            }
        }
        return "";
    }

    private ExtImpEmxDigital unpackImpExt(Imp imp) {
        int tagidNumber;
        ExtImpEmxDigital bidder;
        try {
            bidder = (ExtImpEmxDigital)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), EMXDIGITAL_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage(), e);
        }
        try {
            tagidNumber = Integer.parseInt(bidder.getTagid());
        }
        catch (NumberFormatException e) {
            throw new PreBidException("tagid must be a String of numbers, ignoring imp id=" + imp.getId(), e);
        }
        if (tagidNumber == 0) {
            throw new PreBidException("tagid cant be 0, ignoring imp id=" + imp.getId());
        }
        return bidder;
    }

    private static Imp modifyImp(Imp imp, boolean isSecure, ExtImpEmxDigital extImpEmxDigital) {
        BigDecimal bidfloor;
        Imp.ImpBuilder impBuilder = imp.toBuilder().tagid(extImpEmxDigital.getTagid()).secure(BooleanUtils.toInteger((boolean)isSecure));
        Video video = imp.getVideo();
        if (video != null) {
            impBuilder.video(EmxDigitalBidder.modifyImpVideo(video));
        } else {
            impBuilder.banner(EmxDigitalBidder.modifyImpBanner(imp.getBanner()));
        }
        String stringBidfloor = extImpEmxDigital.getBidfloor();
        if (StringUtils.isBlank((CharSequence)stringBidfloor)) {
            return impBuilder.build();
        }
        try {
            bidfloor = new BigDecimal(stringBidfloor);
        }
        catch (NumberFormatException e) {
            return impBuilder.build();
        }
        return impBuilder.bidfloor(bidfloor).bidfloorcur(USD_CURRENCY).build();
    }

    private static Video modifyImpVideo(Video video) {
        if (CollectionUtils.isEmpty(video.getMimes())) {
            throw new PreBidException("Video: missing required field mimes");
        }
        if (EmxDigitalBidder.isNotPresentSize(video.getH()) && EmxDigitalBidder.isNotPresentSize(video.getW())) {
            throw new PreBidException("Video: Need at least one size to build request");
        }
        if (CollectionUtils.isNotEmpty(video.getProtocols())) {
            List<Integer> updatedProtocols = EmxDigitalBidder.removeVast40Protocols(video.getProtocols());
            return video.toBuilder().protocols(updatedProtocols).build();
        }
        return video;
    }

    private static boolean isNotPresentSize(Integer size) {
        return Objects.isNull(size) || size == 0;
    }

    private static List<Integer> removeVast40Protocols(List<Integer> protocols) {
        return protocols.stream().filter(protocol -> !protocol.equals(PROTOCOL_VAST_40)).toList();
    }

    private static Banner modifyImpBanner(Banner banner) {
        if (banner == null) {
            throw new PreBidException("Request needs to include a Banner object");
        }
        if (banner.getW() == null && banner.getH() == null) {
            Banner.BannerBuilder bannerBuilder = banner.toBuilder();
            List<Format> originalFormat = banner.getFormat();
            if (originalFormat == null || originalFormat.isEmpty()) {
                throw new PreBidException("Need at least one size to build request");
            }
            List<Format> formatSkipFirst = originalFormat.subList(1, originalFormat.size());
            bannerBuilder.format(formatSkipFirst);
            Format firstFormat = originalFormat.get(0);
            bannerBuilder.w(firstFormat.getW());
            bannerBuilder.h(firstFormat.getH());
            return bannerBuilder.build();
        }
        return banner;
    }

    private static MultiMap makeHeaders(BidRequest request) {
        Site site;
        String page;
        MultiMap headers = HttpUtil.headers();
        Device device = request.getDevice();
        if (device != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.USER_AGENT_HEADER, device.getUa());
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.X_FORWARDED_FOR_HEADER, device.getIp());
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.ACCEPT_LANGUAGE_HEADER, device.getLanguage());
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.DNT_HEADER, Objects.toString(device.getDnt(), null));
        }
        String string = page = (site = request.getSite()) != null ? site.getPage() : null;
        if (StringUtils.isNotBlank((CharSequence)page)) {
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.REFERER_HEADER, page);
        }
        return headers;
    }

    private String makeUrl(BidRequest bidRequest) {
        Long tmax = bidRequest.getTmax();
        int urlTimeout = tmax == 0L ? 1000 : tmax.intValue();
        return "%s?t=%s&ts=%s&src=pbserver".formatted(this.endpointUrl, urlTimeout, (int)Instant.now().getEpochSecond());
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues(EmxDigitalBidder.extractBids(bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse) {
        return bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid()) ? Collections.emptyList() : EmxDigitalBidder.bidsFromResponse(bidResponse);
    }

    private static List<BidderBid> bidsFromResponse(BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of(bid, EmxDigitalBidder.getBidType(bid.getAdm()), bidResponse.getCur())).toList();
    }

    private static BidType getBidType(String bidAdm) {
        return StringUtils.containsAny((CharSequence)bidAdm, (CharSequence[])new CharSequence[]{"<?xml", "<vast"}) ? BidType.video : BidType.banner;
    }
}

