/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.decenterads;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class DecenteradsBidder
implements Bidder<BidRequest> {
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public DecenteradsBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ArrayList<HttpRequest<BidRequest>> validRequests = new ArrayList<HttpRequest<BidRequest>>();
        for (Imp imp : request.getImp()) {
            try {
                ObjectNode decenteradsImpExt = DecenteradsBidder.parseAndValidateImpExt(imp.getExt());
                Imp updatedImp = DecenteradsBidder.updateImp(imp, decenteradsImpExt);
                validRequests.add(this.createRequest(request, updatedImp));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        return Result.of(validRequests, errors);
    }

    private static ObjectNode parseAndValidateImpExt(ObjectNode impExt) {
        JsonNode ext = impExt.get("bidder");
        if (ext.isEmpty() || !ext.isObject()) {
            throw new PreBidException("bidder parameters required");
        }
        return (ObjectNode)ext;
    }

    private static Imp updateImp(Imp imp, ObjectNode impExt) {
        return imp.toBuilder().ext(impExt).build();
    }

    private HttpRequest<BidRequest> createRequest(BidRequest request, Imp requestImp) {
        BidRequest outgoingRequest = request.toBuilder().imp(Collections.singletonList(requestImp)).build();
        return BidderUtil.defaultRequest(outgoingRequest, this.endpointUrl, this.mapper);
    }

    @Override
    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of(DecenteradsBidder.extractBids(httpCall.getRequest().getPayload(), bidResponse), Collections.emptyList());
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return DecenteradsBidder.bidsFromResponse(bidRequest, bidResponse);
    }

    private static List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of(bid, DecenteradsBidder.getBidType(bid.getImpid(), bidRequest.getImp()), bidResponse.getCur())).toList();
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getXNative() != null) {
                return BidType.xNative;
            }
            if (imp.getAudio() == null) continue;
            return BidType.audio;
        }
        return BidType.banner;
    }
}

