/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.appush;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.appush.proto.AppushImpExtBidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.appush.ExtImpAppush;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class AppushBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpAppush>> APPUSH_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpAppush>>(){};
    private static final String PUBLISHER_PROPERTY = "publisher";
    private static final String NETWORK_PROPERTY = "network";
    private static final String BIDDER_PROPERTY = "bidder";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public AppushBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<HttpRequest<BidRequest>> httpRequests = new ArrayList<HttpRequest<BidRequest>>();
        for (Imp imp : request.getImp()) {
            ExtImpAppush extImpAppush;
            try {
                extImpAppush = this.parseExtImp(imp);
            }
            catch (PreBidException e) {
                return Result.withError(BidderError.badInput(e.getMessage()));
            }
            Imp modifiedImp = this.modifyImp(imp, extImpAppush);
            httpRequests.add(this.makeHttpRequest(request, modifiedImp));
        }
        return Result.withValues(httpRequests);
    }

    private Imp modifyImp(Imp imp, ExtImpAppush extImpAppush) {
        AppushImpExtBidder impExtAppushWithType = this.resolveImpExt(extImpAppush);
        ObjectNode modifiedImpExtBidder = this.mapper.mapper().createObjectNode();
        modifiedImpExtBidder.set(BIDDER_PROPERTY, this.mapper.mapper().valueToTree((Object)impExtAppushWithType));
        return imp.toBuilder().ext(modifiedImpExtBidder).build();
    }

    private AppushImpExtBidder resolveImpExt(ExtImpAppush extImpAppush) {
        AppushImpExtBidder.AppushImpExtBidderBuilder builder = AppushImpExtBidder.builder();
        if (StringUtils.isNotEmpty((CharSequence)extImpAppush.getPlacementId())) {
            builder.type(PUBLISHER_PROPERTY).placementId(extImpAppush.getPlacementId());
        } else if (StringUtils.isNotEmpty((CharSequence)extImpAppush.getEndpointId())) {
            builder.type(NETWORK_PROPERTY).endpointId(extImpAppush.getEndpointId());
        }
        return builder.build();
    }

    private ExtImpAppush parseExtImp(Imp imp) {
        try {
            return (ExtImpAppush)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), APPUSH_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private HttpRequest<BidRequest> makeHttpRequest(BidRequest request, Imp imp) {
        BidRequest outgoingRequest = request.toBuilder().imp(List.of(imp)).build();
        return BidderUtil.defaultRequest(outgoingRequest, this.endpointUrl, this.mapper);
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            List<BidderBid> bids = AppushBidder.extractBids(httpCall.getRequest().getPayload(), bidResponse);
            return Result.withValues(bids);
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> BidderBid.of(bid, AppushBidder.getBidType(bid.getImpid(), bidRequest.getImp()), bidResponse.getCur())).toList();
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getXNative() == null) break;
            return BidType.xNative;
        }
        throw new PreBidException(String.format("Failed to find impression for ID: '%s'", impId));
    }
}

