/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.adtrgtme;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.adtrgtme.ExtImpAdtrgtme;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;

public class AdtrgtmeBidder
implements Bidder<BidRequest> {
    private static final String X_OPENRTB_VERSION = "2.5";
    private static final TypeReference<ExtPrebid<?, ExtImpAdtrgtme>> ADTRGTME_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpAdtrgtme>>(){};
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public AdtrgtmeBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<HttpRequest<BidRequest>> requests = new ArrayList<HttpRequest<BidRequest>>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        for (Imp imp : request.getImp()) {
            try {
                ExtImpAdtrgtme impAdtrgtme = this.parseImpExt(imp);
                BidRequest updatedRequest = AdtrgtmeBidder.createRequest(request, imp);
                requests.add(this.makeHttpRequest(updatedRequest, impAdtrgtme.getSiteId()));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        return Result.of(requests, errors);
    }

    private ExtImpAdtrgtme parseImpExt(Imp imp) {
        try {
            return (ExtImpAdtrgtme)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), ADTRGTME_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("ext.bidder not provided");
        }
    }

    private static BidRequest createRequest(BidRequest request, Imp imp) {
        return request.toBuilder().imp(Collections.singletonList(AdtrgtmeBidder.prepareImp(imp))).build();
    }

    private static Imp prepareImp(Imp imp) {
        return imp.toBuilder().ext(null).build();
    }

    private HttpRequest<BidRequest> makeHttpRequest(BidRequest bidRequest, Integer siteId) {
        return HttpRequest.builder().method(HttpMethod.POST).uri(this.makeUrl(siteId)).headers(this.makeRequestHeaders(bidRequest.getDevice())).body(this.mapper.encodeToBytes(bidRequest)).payload(bidRequest).build();
    }

    private String makeUrl(Integer siteId) {
        return "%s?s=%d&prebid".formatted(this.endpointUrl, siteId);
    }

    private MultiMap makeRequestHeaders(Device device) {
        MultiMap headers = HttpUtil.headers();
        headers.set(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)X_OPENRTB_VERSION);
        HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.USER_AGENT_HEADER, ObjectUtil.getIfNotNull(device, Device::getUa));
        HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.X_FORWARDED_FOR_HEADER, ObjectUtil.getIfNotNull(device, Device::getIpv6));
        HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.X_FORWARDED_FOR_HEADER, ObjectUtil.getIfNotNull(device, Device::getIp));
        return headers;
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            List<Imp> imps = httpCall.getRequest().getPayload().getImp();
            List<BidderBid> bidderBids = this.extractBids(bidResponse, errors, imps);
            return Result.of(bidderBids, errors);
        }
        catch (DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidResponse bidResponse, List<BidderError> errors, List<Imp> imps) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> this.resolveBidderBid(bidResponse.getCur(), imps, (Bid)bid, errors)).filter(Objects::nonNull).toList();
    }

    private BidderBid resolveBidderBid(String currency, List<Imp> imps, Bid bid, List<BidderError> errors) {
        BidType bidType;
        try {
            bidType = this.getBidType(bid.getImpid(), imps);
        }
        catch (PreBidException e) {
            errors.add(BidderError.badServerResponse(e.getMessage()));
            return null;
        }
        return BidderBid.of(bid, bidType, currency);
    }

    private BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            throw new PreBidException(String.format("Unsupported bidtype for bid: \"%s\"", impId));
        }
        throw new PreBidException("Failed to find impression \"%s\"".formatted(impId));
    }
}

